/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.webserver;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ServletUtil {
    public static String findMapping(String path, Map<String, String> mappings) {
        String regexCandidate = null;
        String pathCandidate = null;
        String master = null;
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            if (entry.getKey().toLowerCase().equals("/") || entry.getKey().toLowerCase().equals("/*")) {
                master = entry.getValue();
                continue;
            }
            if (path.toLowerCase().matches(ServletUtil.buildPathRegex(entry.getKey().toLowerCase()))) {
                regexCandidate = entry.getValue();
                continue;
            }
            if (!path.equalsIgnoreCase(entry.getKey().toLowerCase()) && (!entry.getKey().toLowerCase().endsWith("/") || !path.toLowerCase().startsWith(entry.getKey().toLowerCase())) && (!entry.getKey().toLowerCase().endsWith("*") || !path.toLowerCase().startsWith(entry.getKey().substring(0, entry.getKey().length() - 1).toLowerCase()))) continue;
            pathCandidate = entry.getValue();
        }
        if (regexCandidate != null) {
            return regexCandidate;
        }
        if (pathCandidate != null) {
            return pathCandidate;
        }
        return master;
    }

    public static List<String> findAllMappings(String path, Map<String, String> mappings) {
        LinkedList<String> foundMappings = new LinkedList<String>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            if (entry.getKey().toLowerCase().equals("/") || entry.getKey().toLowerCase().equals("/*")) {
                foundMappings.add(entry.getValue());
                continue;
            }
            if (path.toLowerCase().matches(ServletUtil.buildPathRegex(entry.getKey().toLowerCase()))) {
                foundMappings.add(entry.getValue());
                continue;
            }
            if (!path.equalsIgnoreCase(entry.getKey().toLowerCase()) && (!entry.getKey().toLowerCase().endsWith("/") || !path.toLowerCase().startsWith(entry.getKey().toLowerCase())) && (!entry.getKey().toLowerCase().endsWith("*") || !path.toLowerCase().startsWith(entry.getKey().substring(0, entry.getKey().length() - 1).toLowerCase()))) continue;
            foundMappings.add(entry.getValue());
        }
        return foundMappings;
    }

    public static String buildPathRegex(String path) {
        StringBuilder regex = new StringBuilder();
        String[] parts = path.split("[\\x2A]");
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                regex.append(".*");
            }
            regex.append(Pattern.quote(parts[i]));
        }
        return regex.toString();
    }

    public static boolean matchesMapping(String path, String ... mappings) {
        for (String mapping : mappings) {
            if (mapping.toLowerCase().equals("/") || mapping.toLowerCase().equals("/*")) {
                return true;
            }
            if (path.toLowerCase().matches(ServletUtil.buildPathRegex(mapping.toLowerCase()))) {
                return true;
            }
            if (!path.equalsIgnoreCase(mapping.toLowerCase()) && (!mapping.toLowerCase().endsWith("/") || !path.toLowerCase().startsWith(mapping.toLowerCase())) && (!mapping.toLowerCase().endsWith("*") || !path.toLowerCase().startsWith(mapping.substring(0, mapping.length() - 1).toLowerCase()))) continue;
            return true;
        }
        return false;
    }
}

