/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.security.liferay;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LiferayAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(LiferayAuthenticationProvider.class);
    private Long companyId = null;

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        log.debug("Checking authorization {}", (Object)authentication);
        if (!authentication.isAuthenticated()) {
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                try {
                    UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (UsernamePasswordAuthenticationToken)authentication;
                    String username = usernamePasswordAuthenticationToken.getPrincipal().toString();
                    String password = usernamePasswordAuthenticationToken.getCredentials().toString();
                    for (Company company : CompanyLocalServiceUtil.getCompanies()) {
                        if (this.companyId != null && company.getCompanyId() != this.companyId.longValue()) continue;
                        User user = null;
                        try {
                            user = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)username);
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            // empty catch block
                        }
                        if (user == null || !user.isActive() || user.isLockout()) {
                            return null;
                        }
                        boolean passwordValid = false;
                        if (user.isPasswordEncrypted()) {
                            log.debug("Password is encrypted");
                            String encryptedPassword = PasswordEncryptorUtil.encrypt((String)password, (String)user.getPassword());
                            passwordValid = user.getPassword().equals(encryptedPassword);
                        } else {
                            log.debug("Password is not encrypted");
                            passwordValid = user.getPassword().equals(password);
                        }
                        if (!passwordValid) continue;
                        PrincipalThreadLocal.setName((long)user.getUserId());
                        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                        LinkedList<SimpleGrantedAuthority> authorities = new LinkedList<SimpleGrantedAuthority>();
                        for (Role role : RoleServiceUtil.getUserRoles((long)user.getUserId())) {
                            authorities.add(new SimpleGrantedAuthority(role.getName()));
                        }
                        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password, authorities);
                        return token;
                    }
                }
                catch (Exception e) {
                    log.error("Error while authentication via liferay user database", (Throwable)e);
                }
            } else {
                log.warn("Unsupported authentication {}", (Object)authentication);
            }
            return null;
        }
        return authentication;
    }

    public boolean supports(Class<?> authentication) {
        log.debug("Checking support for authentication {}", authentication);
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }
}

