/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.formatter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import si.nevensrok.common.web.formatter.AbstractFormatterFactory;
import si.nevensrok.common.web.formatter.DecimalNumberFormatter;

public class DecimalNumberFormatterFactory
extends AbstractFormatterFactory<DecimalNumberFormatter> {
    public DecimalNumberFormatterFactory() {
        super(new Class[]{Integer.class, Long.class, Float.class, Double.class});
    }

    public Printer<?> getPrinter(final DecimalNumberFormatter annotation, Class<?> fieldType) {
        if (fieldType.equals(Integer.class)) {
            return new Printer<Integer>(){

                public String print(Integer number, Locale locale) {
                    if (number == null) {
                        return "";
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    return decimalFormat.format(number);
                }
            };
        }
        if (fieldType.equals(Long.class)) {
            return new Printer<Long>(){

                public String print(Long number, Locale locale) {
                    if (number == null) {
                        return "";
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    return decimalFormat.format(number);
                }
            };
        }
        if (fieldType.equals(Float.class)) {
            return new Printer<Float>(){

                public String print(Float number, Locale locale) {
                    if (number == null) {
                        return "";
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    return decimalFormat.format(number);
                }
            };
        }
        if (fieldType.equals(Double.class)) {
            return new Printer<Double>(){

                public String print(Double number, Locale locale) {
                    if (number == null) {
                        return "";
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    return decimalFormat.format(number);
                }
            };
        }
        throw new RuntimeException("Printer not found for type " + fieldType.getName());
    }

    public Parser<?> getParser(final DecimalNumberFormatter annotation, Class<?> fieldType) {
        if (fieldType.equals(Integer.class)) {
            return new Parser<Integer>(){

                public Integer parse(String text, Locale locale) throws ParseException {
                    if (text == null || text.trim().isEmpty()) {
                        return Integer.parseInt(annotation.defaultValue());
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    if (annotation.unifyDecimalSeperator()) {
                        text = text.replace('.', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                        text = text.replace(',', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                    }
                    try {
                        return decimalFormat.parse(text.trim()).intValue();
                    }
                    catch (Exception e) {
                        return Integer.parseInt(annotation.defaultValue());
                    }
                }
            };
        }
        if (fieldType.equals(Long.class)) {
            return new Parser<Long>(){

                public Long parse(String text, Locale locale) throws ParseException {
                    if (text == null || text.trim().isEmpty()) {
                        return Long.parseLong(annotation.defaultValue());
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    if (annotation.unifyDecimalSeperator()) {
                        text = text.replace('.', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                        text = text.replace(',', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                    }
                    try {
                        return decimalFormat.parse(text.trim()).longValue();
                    }
                    catch (Exception e) {
                        return Long.parseLong(annotation.defaultValue());
                    }
                }
            };
        }
        if (fieldType.equals(Float.class)) {
            return new Parser<Float>(){

                public Float parse(String text, Locale locale) throws ParseException {
                    if (text == null || text.trim().isEmpty()) {
                        return Float.valueOf(Float.parseFloat(annotation.defaultValue()));
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    if (annotation.unifyDecimalSeperator()) {
                        text = text.replace('.', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                        text = text.replace(',', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                    }
                    try {
                        return Float.valueOf(decimalFormat.parse(text.trim()).floatValue());
                    }
                    catch (Exception e) {
                        return Float.valueOf(Float.parseFloat(annotation.defaultValue()));
                    }
                }
            };
        }
        if (fieldType.equals(Double.class)) {
            return new Parser<Double>(){

                public Double parse(String text, Locale locale) throws ParseException {
                    if (text == null || text.trim().isEmpty()) {
                        return Double.parseDouble(annotation.defaultValue());
                    }
                    DecimalFormat decimalFormat = DecimalNumberFormatterFactory.this.createDecimalFormat(annotation, locale);
                    if (annotation.unifyDecimalSeperator()) {
                        text = text.replace('.', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                        text = text.replace(',', decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
                    }
                    try {
                        return decimalFormat.parse(text.trim()).doubleValue();
                    }
                    catch (Exception e) {
                        return Double.parseDouble(annotation.defaultValue());
                    }
                }
            };
        }
        throw new RuntimeException("Parser not found for type " + fieldType.getName());
    }

    private DecimalFormat createDecimalFormat(DecimalNumberFormatter annotation, Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        if (annotation.decimalSeparator() != null && !annotation.decimalSeparator().isEmpty()) {
            char decimalSeparator = this.getLocalizedMessage(annotation.decimalSeparator(), locale).charAt(0);
            decimalFormatSymbols.setDecimalSeparator(decimalSeparator);
        }
        if (annotation.groupingSeparator() != null && !annotation.groupingSeparator().isEmpty()) {
            char groupingSeparator = this.getLocalizedMessage(annotation.groupingSeparator(), locale).charAt(0);
            decimalFormatSymbols.setGroupingSeparator(groupingSeparator);
        }
        DecimalFormat decimalFormat = new DecimalFormat(this.getLocalizedMessage(annotation.value(), locale), decimalFormatSymbols);
        return decimalFormat;
    }
}

