/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.hibernate;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.hibernate.PostgresPartitionBatch;

public class PostgresPartitionBatchBuilder
implements BatchBuilder,
Configurable {
    private static final long serialVersionUID = -8410230766928421973L;
    private static final Logger log = LoggerFactory.getLogger(PostgresPartitionBatchBuilder.class);
    private int size;

    public PostgresPartitionBatchBuilder() {
    }

    public PostgresPartitionBatchBuilder(int size) {
        this.size = size;
    }

    public void configure(Map configurationValues) {
        this.size = ConfigurationHelper.getInt((String)"hibernate.jdbc.batch_size", (Map)configurationValues, (int)this.size);
    }

    public void setJdbcBatchSize(int size) {
        this.size = size;
    }

    public Batch buildBatch(BatchKey key, JdbcCoordinator jdbcCoordinator) {
        log.trace("Building batch [size={}]", (Object)this.size);
        return new PostgresPartitionBatch(key, jdbcCoordinator, this.size);
    }

    @Deprecated
    public String getManagementDomain() {
        return null;
    }

    @Deprecated
    public String getManagementServiceType() {
        return null;
    }

    @Deprecated
    public Object getManagementBean() {
        return this;
    }
}

