/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetesInCategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CoupleCompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.PersonCompetitorDTO;

public class CompetitorDAO
extends ExtendedDao<Long, CompetitorDTO, Competitor> {
    private static final Logger log = LoggerFactory.getLogger(CompetitorDAO.class);

    public CompetitorDAO() {
        super(CompetitorDTO.class, Competitor.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.compareToIgnoreCase("id") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("competitorId") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("competition") == 0) {
            return "c.competition.id";
        }
        if (fieldName.compareToIgnoreCase("club") == 0) {
            return "c.club.id";
        }
        if (fieldName.compareToIgnoreCase("name") == 0) {
            return "c.name";
        }
        if (fieldName.compareToIgnoreCase("surname") == 0) {
            return "c.surname";
        }
        if (fieldName.compareToIgnoreCase("shortName") == 0) {
            return "c.shortName";
        }
        if (fieldName.compareToIgnoreCase("yearOfBirth") == 0) {
            return "c.yearOfBirth";
        }
        if (fieldName.compareToIgnoreCase("weight") == 0) {
            return "c.weight";
        }
        if (fieldName.compareToIgnoreCase("drawNumber") == 0) {
            return "competesInCategory.drawNumber";
        }
        if (fieldName.compareToIgnoreCase("status") == 0) {
            return "c.status";
        }
        if (fieldName.compareToIgnoreCase("type") == 0) {
            return "c.type";
        }
        if (fieldName.compareToIgnoreCase("name1") == 0) {
            return "c.name1";
        }
        if (fieldName.compareToIgnoreCase("surname1") == 0) {
            return "c.surname1";
        }
        if (fieldName.compareToIgnoreCase("name2") == 0) {
            return "c.name2";
        }
        if (fieldName.compareToIgnoreCase("surname2") == 0) {
            return "c.surname2";
        }
        if (fieldName.compareToIgnoreCase("yearOfBirth1") == 0) {
            return "c.yearOfBirth1";
        }
        if (fieldName.compareToIgnoreCase("yearOfBirth2") == 0) {
            return "c.yearOfBirth2";
        }
        if (fieldName.compareToIgnoreCase("club.name") == 0) {
            return "c.club.name";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void addCompetitorToCategory(Competitor competitor, Category category) {
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        CompetitorDTO competitorDTO = new CompetitorDTO();
        competitorDTO.setCompetitorId(competitor.getCompetitorId());
        CompetesInCategoryDTO competesInCategoryDTO = new CompetesInCategoryDTO(categoryDTO, competitorDTO);
        competesInCategoryDTO.setDrawNumber(null);
        this.getCurrentSession().saveOrUpdate((Object)competesInCategoryDTO);
        this.flush();
    }

    public void removeCompetitorFromCategory(Competitor competitor, Category category) {
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        CompetitorDTO competitorDTO = new CompetitorDTO();
        competitorDTO.setCompetitorId(competitor.getCompetitorId());
        CompetesInCategoryDTO competesInCategoryDTO = new CompetesInCategoryDTO(categoryDTO, competitorDTO);
        this.getCurrentSession().delete((Object)competesInCategoryDTO);
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update MatchDTO set competitor1=null where category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and competitor1.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor2=null where category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and competitor2.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCompetitorCategories(Competitor competitor, Set<Category> categories) {
        Category category;
        HashSet<Long> newCategories = new HashSet<Long>();
        for (Category category2 : categories) {
            newCategories.add(category2.getCategoryId());
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("from CompetesInCategoryDTO where competesInCategoryKey.competitor.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List currentList = query.getResultList();
        HashSet categoriesToAdd = new HashSet(newCategories);
        HashSet<Long> categoriesToRemove = new HashSet<Long>();
        for (Object item : currentList) {
            CompetesInCategoryDTO competesInCategoryDTO = (CompetesInCategoryDTO)item;
            Long categoryId = competesInCategoryDTO.getCompetesInCategoryKey().getCategory().getCategoryId();
            if (newCategories.contains(categoryId)) {
                categoriesToAdd.remove(categoryId);
                continue;
            }
            categoriesToRemove.add(categoryId);
        }
        this.flush();
        for (Long categoryId : categoriesToAdd) {
            category = new Category();
            category.setCategoryId(categoryId);
            this.addCompetitorToCategory(competitor, category);
        }
        for (Long categoryId : categoriesToRemove) {
            category = new Category();
            category.setCategoryId(categoryId);
            this.removeCompetitorFromCategory(competitor, category);
        }
    }

    public List<Competitor> getCompetitorsForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForCategory(Category category, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        sqlQuery.append(" and competesInCategory.competesInCategoryKey.competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForClub(Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.club.clubId=");
        sqlQuery.append(params.addParam(club.getClubId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getCompetitorsForClub(Club club, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.club.clubId=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (Object item : result) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, item);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public Page<Competitor> findForCompetition(Competition competition, Page<Competitor> page) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("from CompetitorDTO as c where c.competition=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        if (page.getFilter() != null) {
            StringBuilder filterQuery = new StringBuilder();
            try {
                this.addFilter(filterQuery, params, page.getFilter(), false);
            }
            catch (Exception e) {
                log.error("Error adding filters", (Throwable)e);
            }
            if (filterQuery.length() > 0) {
                sqlQuery.append(" and");
                sqlQuery.append((CharSequence)filterQuery);
            }
        }
        Query query = this.createQuery("select count(c) " + sqlQuery.toString());
        params.bindParams(query);
        Long totalRowCount = Long.parseLong(CompetitorDAO.getSingleResult((Query)query).toString());
        try {
            this.addSort(sqlQuery, page.getSort());
        }
        catch (Exception e) {
            log.error("Error adding sort conditions", (Throwable)e);
        }
        query = this.createQuery("select c,c.club " + sqlQuery.toString());
        params.bindParams(query);
        if (page.getStartIndex() != null) {
            query.setFirstResult(page.getStartIndex().intValue());
        }
        if (page.getPageRowLimitCount() != null) {
            query.setMaxResults(page.getPageRowLimitCount().intValue());
        }
        List result = query.getResultList();
        LinkedList<Competitor> list = new LinkedList<Competitor>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, parts[0]);
            competitor.setClub((Club)this.adapterPool.create(Club.class, parts[1]));
            list.add(competitor);
        }
        Page returnPage = new Page();
        returnPage.setData(list);
        returnPage.setTotalRowCount(totalRowCount);
        this.flush();
        return returnPage;
    }

    public void changeCompetitorStatus(Competitor competitor, Competitor.Status status) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update CompetitorDTO set status=");
        sqlQuery.append(params.addParam((Object)status));
        sqlQuery.append(" where id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCompetitorsClub(Competitor competitor, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update CompetitorDTO set club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" where id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public PersonCompetitor getActivePersonCompetitorByNameAndClub(Competition competition, String firstName, String lastName, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from PersonCompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(competitor.name)=UPPER(");
        sqlQuery.append(params.addParam(firstName));
        sqlQuery.append(") and UPPER(competitor.surname)=UPPER(");
        sqlQuery.append(params.addParam(lastName));
        sqlQuery.append(") and competitor.club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        PersonCompetitorDTO personCompetitorDTO = (PersonCompetitorDTO)((Object)CompetitorDAO.getSingleResult((Query)query));
        PersonCompetitor personCompetitor = null;
        if (personCompetitorDTO != null) {
            personCompetitor = (PersonCompetitor)this.adapterPool.create(PersonCompetitor.class, (Object)personCompetitorDTO);
        }
        this.flush();
        return personCompetitor;
    }

    public CoupleCompetitor getActiveCoupleCompetitorByNameAndClub(Competition competition, String firstName1, String lastName1, String firstName2, String lastName2, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CoupleCompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(competitor.name1)=UPPER(");
        sqlQuery.append(params.addParam(firstName1));
        sqlQuery.append(") and UPPER(competitor.surname1)=UPPER(");
        sqlQuery.append(params.addParam(lastName1));
        sqlQuery.append(") and UPPER(competitor.name2)=UPPER(");
        sqlQuery.append(params.addParam(firstName2));
        sqlQuery.append(") and UPPER(competitor.surname2)=UPPER(");
        sqlQuery.append(params.addParam(lastName2));
        sqlQuery.append(") and competitor.club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CoupleCompetitorDTO coupleCompetitorDTO = (CoupleCompetitorDTO)((Object)CompetitorDAO.getSingleResult((Query)query));
        CoupleCompetitor coupleCompetitor = null;
        if (coupleCompetitorDTO != null) {
            coupleCompetitor = (CoupleCompetitor)this.adapterPool.create(CoupleCompetitor.class, (Object)coupleCompetitorDTO);
        }
        this.flush();
        return coupleCompetitor;
    }

    public List<Competitor> getCompetitorsForCompetiton(Competition competition, Competitor.Type type, int minumumMatchCount) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)type));
        sqlQuery.append(" and (select count(*) from MatchDTO as match where (match.competitor1.id=competitor.id or match.competitor2.id=competitor.id) and match.status=");
        sqlQuery.append(params.addParam((Object)Match.Status.FINISHED));
        sqlQuery.append(")>=");
        sqlQuery.append(params.addParam(Integer.valueOf(minumumMatchCount)));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public void removeCompetitorFromAllCategories(Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from CompetesInCategoryDTO where competesInCategoryKey.competitor.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor1=null where competitor1.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        params = new ParamsBinder();
        sql = new StringBuilder();
        sql.append("update MatchDTO set competitor2=null where competitor2.id=");
        sql.append(params.addParam(competitor.getCompetitorId()));
        query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public List<Competitor> getActiveCompetitorsForCompetition(Competition competition, Competitor.Type competitorType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor from CompetitorDTO as competitor where competitor.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and competitor.status=");
        sqlQuery.append(params.addParam((Object)Competitor.Status.ACTIVE));
        sqlQuery.append(" and competitor.type=");
        sqlQuery.append(params.addParam((Object)competitorType));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.adapterPool.create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }
}

