/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.lock.LockService;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;

public class CategoryTreeUpdateManagerImpl
implements CategoryTreeUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(CategoryTreeUpdateManagerImpl.class);
    private MatchManager matchManager;
    private CategoryManager categoryManager;
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private LockService lockService;

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategory(Category category) {
        if (category == null || category.getCategoryId() == null) {
            return;
        }
        this.lockCategory(category);
        category = this.categoryManager.getById(category.getCategoryId());
        if (log.isDebugEnabled()) {
            log.debug("Updateing category tree for category {}", (Object)category);
        }
        try {
            int i;
            if (!(category instanceof TreeCategory)) {
                throw new RuntimeException("Category is not instance of TreeCategory");
            }
            TreeCategory treeCategory = (TreeCategory)category;
            Competition competition = this.competitionManager.getCompetitionForCategory(category);
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
            HashMap matchPoints = new HashMap();
            for (Match match : this.matchManager.getMatchesForCategory(category)) {
                matches.put(match.getFightNumber(), match);
            }
            for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
                matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
            }
            TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
            Map map = this.categoryManager.getDrawAsNumber(category);
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
                Match match;
                for (i = 1; i <= 10; ++i) {
                    match = (Match)matches.get(i);
                    TreeAdvancmentItem treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TABLE);
                    TreeAdvancmentItem treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TABLE);
                    match.setCompetitor1((Competitor)map.get(treeAdvancmentItem1.getFromMatch()));
                    match.setCompetitor2((Competitor)map.get(treeAdvancmentItem2.getFromMatch()));
                    if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 && (treeAdvancmentItem1.getFromMatch() == 1 && treeAdvancmentItem2.getFromMatch() == 2 || treeAdvancmentItem1.getFromMatch() == 2 && treeAdvancmentItem2.getFromMatch() == 1) || match.getCompetitor1() != null && match.getCompetitor2() != null) {
                        match.setNotNeeded(Boolean.valueOf(false));
                        match.setMatchEmpty(Boolean.valueOf(false));
                        continue;
                    }
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(false));
                }
                for (i = 11; i <= 124; ++i) {
                    match = (Match)matches.get(i);
                    match.setCompetitor1(null);
                    match.setCompetitor2(null);
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(true));
                }
            } else {
                for (i = 1; i <= 124; ++i) {
                    Match match = (Match)matches.get(i);
                    if (log.isTraceEnabled()) {
                        log.trace("Calculating for match num {}, match={}", (Object)i, (Object)match);
                    }
                    TreeAdvancmentItem treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                    TreeAdvancmentItem treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                    Match fromMatch1 = (Match)matches.get(treeAdvancmentItem1.getFromMatch());
                    Match fromMatch2 = (Match)matches.get(treeAdvancmentItem2.getFromMatch());
                    Competitor competitor1 = null;
                    Competitor competitor2 = null;
                    if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW) {
                        competitor1 = (Competitor)map.get(treeAdvancmentItem1.getFromMatch());
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        if (fromMatch1.getNotNeeded().booleanValue()) {
                            if (fromMatch1.getCompetitor1() != null) {
                                competitor1 = fromMatch1.getCompetitor1();
                            } else if (fromMatch1.getCompetitor2() != null) {
                                competitor1 = fromMatch1.getCompetitor2();
                            }
                        } else if (fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                            competitor1 = competitionRules.getMatchWinner(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                        }
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && !fromMatch1.getNotNeeded().booleanValue() && fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                        competitor1 = competitionRules.getMatchLoser(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                        competitor2 = (Competitor)map.get(treeAdvancmentItem2.getFromMatch());
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        if (fromMatch2.getNotNeeded().booleanValue()) {
                            if (fromMatch2.getCompetitor1() != null) {
                                competitor2 = fromMatch2.getCompetitor1();
                            } else if (fromMatch2.getCompetitor2() != null) {
                                competitor2 = fromMatch2.getCompetitor2();
                            }
                        } else if (fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                            competitor2 = competitionRules.getMatchWinner(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                        }
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER && !fromMatch2.getNotNeeded().booleanValue() && fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                        competitor2 = competitionRules.getMatchLoser(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                    }
                    if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW || treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                        if (competitor1 == null && competitor2 == null) {
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(true));
                        } else if (competitor1 == null || competitor2 == null) {
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(false));
                        } else {
                            match.setNotNeeded(Boolean.valueOf(false));
                            match.setMatchEmpty(Boolean.valueOf(false));
                        }
                    } else if ((fromMatch1.getMatchEmpty().booleanValue() || treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue()) && (fromMatch2.getMatchEmpty().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue())) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue()) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    } else if (fromMatch1.getMatchEmpty().booleanValue() || fromMatch2.getMatchEmpty().booleanValue()) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    } else {
                        match.setNotNeeded(Boolean.valueOf(false));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    }
                    if (i >= 49 && i <= 64) {
                        if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 1) {
                            competitor1 = null;
                            competitor2 = null;
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(true));
                        }
                    } else if (i >= 65 && i <= 80) {
                        if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 2) {
                            competitor1 = null;
                            competitor2 = null;
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(true));
                        }
                    } else if (i >= 89 && i <= 104) {
                        if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 3) {
                            competitor1 = null;
                            competitor2 = null;
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(true));
                        }
                    } else if (i >= 109 && i <= 116) {
                        if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 4) {
                            competitor1 = null;
                            competitor2 = null;
                            match.setNotNeeded(Boolean.valueOf(true));
                            match.setMatchEmpty(Boolean.valueOf(true));
                        }
                    } else if (i >= 119 && i <= 122 && (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 5)) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                    match.setCompetitor1(competitor1);
                    match.setCompetitor2(competitor2);
                }
                if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getDouble3rdPlace().booleanValue()) {
                    ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(true));
                    ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(true));
                    ((Match)matches.get(123)).setCompetitor1(null);
                    ((Match)matches.get(123)).setCompetitor2(null);
                } else {
                    ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(false));
                    ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(false));
                }
            }
            this.matchManager.updateMatchTreeAdvancmentData(matches.values());
            Map<Competitor, Integer> placings = this.getPlacings(category);
            this.categoryManager.setPlacings((Category)treeCategory, placings);
            if (log.isDebugEnabled()) {
                log.debug("Updateing category tree finished");
            }
        }
        catch (Throwable e) {
            log.error("Error while updating category tree for category " + category.toString(), e);
        }
        finally {
            this.unlockCategory(category);
        }
    }

    public Table getTable(Category category) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        if (log.isDebugEnabled()) {
            log.debug("Calculating table for category {}", (Object)category);
        }
        try {
            if (!(category instanceof TreeCategory)) {
                throw new RuntimeException("Category is not instance of TreeCategory");
            }
            TreeCategory treeCategory = (TreeCategory)category;
            Competition competition = this.competitionManager.getCompetitionForCategory(category);
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
            for (Match match : this.matchManager.getMatchesForCategory(category)) {
                matches.put(match.getFightNumber(), match);
            }
            TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
            Map draw = this.categoryManager.getDraw(category);
            Table table = new Table();
            Table.Row[] rows = treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 ? new Table.Row[2] : (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 ? new Table.Row[3] : (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 ? new Table.Row[4] : new Table.Row[5]));
            table.setRows(rows);
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = new Table.Row();
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2) {
                    rows[i].setMatches(new Table.Row.Match[2]);
                    continue;
                }
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3) {
                    rows[i].setMatches(new Table.Row.Match[3]);
                    continue;
                }
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4) {
                    rows[i].setMatches(new Table.Row.Match[4]);
                    continue;
                }
                rows[i].setMatches(new Table.Row.Match[5]);
            }
            for (Map.Entry entry : draw.entrySet()) {
                if (entry.getValue() == null) continue;
                int n = (Integer)entry.getValue();
                rows[n - 1].setCompetitor((Competitor)entry.getKey());
            }
            for (int i = 0; i < rows.length; ++i) {
                Table.Row row = rows[i];
                Competitor competitor = row.getCompetitor();
                if (competitor == null) continue;
                for (TreeAdvancmentItem treeAdvancmentItem : treeAdvancment.getTableTreeAdvancmentItemsForDraw(i + 1)) {
                    Match match = (Match)matches.get(treeAdvancmentItem.getForMatch());
                    CompetitorType otherCompetitorType = treeAdvancmentItem.getCompetitorType() == CompetitorType.COMPETITOR1 ? CompetitorType.COMPETITOR2 : CompetitorType.COMPETITOR1;
                    TreeAdvancmentItem otherTreeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), otherCompetitorType, TreeType.TABLE);
                    int otherNum = otherTreeAdvancmentItem.getFromMatch();
                    if (otherNum > rows.length) continue;
                    Set points = this.matchManager.getMatchPointsForMatch(match);
                    Competitor winner = competitionRules.getMatchWinner(match, points);
                    Competitor looser = competitionRules.getMatchLoser(match, points);
                    Boolean amIWinner = winner == null ? null : Boolean.valueOf(winner.getCompetitorId().equals(competitor.getCompetitorId()));
                    Boolean amILooser = looser == null ? null : Boolean.valueOf(looser.getCompetitorId().equals(competitor.getCompetitorId()));
                    boolean isFullIpponWin = false;
                    boolean isFullIpponLoose = false;
                    float myPoints = 0.0f;
                    float otherPoints = 0.0f;
                    float myIppons = 0.0f;
                    float otherIppons = 0.0f;
                    Match.Type matchType = null;
                    if (category.getType() == Category.Type.FIGHTING) {
                        matchType = Match.Type.FIGHT;
                    } else if (category.getType() == Category.Type.DUO) {
                        matchType = Match.Type.DUO;
                    } else if (category.getType() == Category.Type.NEWAZA) {
                        matchType = Match.Type.NEWAZA;
                    }
                    if (treeAdvancmentItem.getCompetitorType() == CompetitorType.COMPETITOR1) {
                        isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                        isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                        myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                        otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                        myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
                        otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
                    } else {
                        isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                        isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                        myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                        otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                        myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
                        otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
                    }
                    if (!match.getNoWinner().booleanValue() && match.getStatus() == Match.Status.FINISHED) {
                        if (amIWinner != null && amIWinner.booleanValue()) {
                            row.setWins(Integer.valueOf(row.getWins() + 1));
                        }
                        if (amILooser != null && amILooser.booleanValue()) {
                            row.setLooses(Integer.valueOf(row.getLooses() + 1));
                        }
                        if (isFullIpponWin) {
                            row.setFullIpponWins(Integer.valueOf(row.getFullIpponWins() + 1));
                        }
                        if (isFullIpponLoose) {
                            row.setFullIpponLooses(Integer.valueOf(row.getFullIpponLooses() + 1));
                        }
                        row.setPointsGained(Float.valueOf(row.getPointsGained().floatValue() + myPoints));
                        row.setPointsAgainst(Float.valueOf(row.getPointsAgainst().floatValue() + otherPoints));
                        row.setIpponsGained(Float.valueOf(row.getIpponsGained().floatValue() + myIppons));
                        row.setIpponsAgainst(Float.valueOf(row.getIpponsAgainst().floatValue() + otherIppons));
                    }
                    row.getMatches()[otherNum - 1] = new Table.Row.Match();
                    row.getMatches()[otherNum - 1].setMyPoints(Float.valueOf(myPoints));
                    row.getMatches()[otherNum - 1].setOtherPoints(Float.valueOf(otherPoints));
                    row.getMatches()[otherNum - 1].setAmIWinner(Boolean.valueOf(amIWinner == null ? false : amIWinner));
                }
            }
            return table;
        }
        catch (Exception e) {
            log.error("Error while calcuating tree for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    public Map<Competitor, Integer> getPlacings(Category category) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        if (log.isDebugEnabled()) {
            log.debug("Calculating placings for category {}", (Object)category);
        }
        try {
            if (!(category instanceof TreeCategory)) {
                throw new RuntimeException("Category is not instance of TreeCategory");
            }
            TreeCategory treeCategory = (TreeCategory)category;
            TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
            Competition competition = this.competitionManager.getCompetitionForCategory(category);
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
            HashMap matchPoints = new HashMap();
            HashMap<Integer, Boolean> matchEmpty = new HashMap<Integer, Boolean>();
            for (Match match : this.matchManager.getMatchesForCategory(category)) {
                matches.put(match.getFightNumber(), match);
                matchEmpty.put(match.getFightNumber(), false);
            }
            for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
                matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
            }
            HashMap<Competitor, Integer> placings = new HashMap<Competitor, Integer>();
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
                boolean bl;
                boolean bl2 = true;
                for (int i = 1; i <= 10; ++i) {
                    Table.Row[] match = (Table.Row[])matches.get(i);
                    if (match.getNotNeeded().booleanValue() || match.getStatus() == Match.Status.FINISHED) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    Table table = this.getTable(category);
                    competitionRules.setPlacingsInTable(table);
                    for (Table.Row row : table.getRows()) {
                        if (row.getPlacing() == null || row.getCompetitor() == null) continue;
                        placings.put(row.getCompetitor(), row.getPlacing());
                    }
                }
            } else {
                Match looserMatch;
                Competitor loser;
                TreeAdvancmentItem treeAdvancmentItemWinner4;
                TreeAdvancmentItem treeAdvancmentItemWinner3;
                TreeAdvancmentItem treeAdvancmentItemWinner2;
                TreeAdvancmentItem treeAdvancmentItemWinner1;
                Match looserMatch2;
                Competitor loser2;
                TreeAdvancmentItem treeAdvancmentItem2;
                TreeAdvancmentItem treeAdvancmentItem1;
                int i;
                Competitor loser3;
                Competitor winner;
                Match match = (Match)matches.get(124);
                if (match.getStatus() == Match.Status.FINISHED) {
                    winner = competitionRules.getMatchWinner(match, (Set)matchPoints.get(match.getFightNumber()));
                    Competitor loser32 = competitionRules.getMatchLoser(match, (Set)matchPoints.get(match.getFightNumber()));
                    if (winner != null) {
                        placings.put(winner, 1);
                    }
                    if (loser32 != null) {
                        placings.put(loser32, 2);
                    }
                }
                if (!treeCategory.getDouble3rdPlace().booleanValue()) {
                    Match match2 = (Match)matches.get(123);
                    if (match2.getNotNeeded().booleanValue() && match2.getCompetitor1() == null && match2.getCompetitor2() == null) {
                        Match looserMatch3;
                        Competitor loser4;
                        Match looserMatch32;
                        Competitor loser42;
                        TreeAdvancmentItem treeAdvancmentItem12 = treeAdvancment.getTreeAdvancmentItem(123, CompetitorType.COMPETITOR1, TreeType.TREE);
                        TreeAdvancmentItem treeAdvancmentItem22 = treeAdvancment.getTreeAdvancmentItem(123, CompetitorType.COMPETITOR2, TreeType.TREE);
                        TreeAdvancmentItem treeAdvancmentItemWinner12 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem12.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        TreeAdvancmentItem treeAdvancmentItemWinner22 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem12.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        TreeAdvancmentItem treeAdvancmentItemWinner32 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem22.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        TreeAdvancmentItem treeAdvancmentItemWinner42 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem22.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        if (treeAdvancmentItemWinner12.getSelectType() == SelectType.LOSER && (loser42 = competitionRules.getMatchLoser(looserMatch32 = (Match)matches.get(treeAdvancmentItemWinner12.getFromMatch()), (Set)matchPoints.get(looserMatch32.getFightNumber()))) != null) {
                            placings.put(loser42, 3);
                        }
                        if (treeAdvancmentItemWinner22.getSelectType() == SelectType.LOSER && (loser4 = competitionRules.getMatchLoser(looserMatch3 = (Match)matches.get(treeAdvancmentItemWinner22.getFromMatch()), (Set)matchPoints.get(looserMatch3.getFightNumber()))) != null) {
                            placings.put(loser4, 3);
                        }
                        if (treeAdvancmentItemWinner32.getSelectType() == SelectType.LOSER && (loser4 = competitionRules.getMatchLoser(looserMatch3 = (Match)matches.get(treeAdvancmentItemWinner32.getFromMatch()), (Set)matchPoints.get(looserMatch3.getFightNumber()))) != null) {
                            placings.put(loser4, 3);
                        }
                        if (treeAdvancmentItemWinner42.getSelectType() == SelectType.LOSER && (loser4 = competitionRules.getMatchLoser(looserMatch3 = (Match)matches.get(treeAdvancmentItemWinner42.getFromMatch()), (Set)matchPoints.get(looserMatch3.getFightNumber()))) != null) {
                            placings.put(loser4, 3);
                        }
                    } else if (match2.getStatus() == Match.Status.FINISHED) {
                        winner = competitionRules.getMatchWinner(match2, (Set)matchPoints.get(match2.getFightNumber()));
                        loser3 = competitionRules.getMatchLoser(match2, (Set)matchPoints.get(match2.getFightNumber()));
                        if (winner != null) {
                            placings.put(winner, 3);
                        }
                        if (loser3 != null) {
                            placings.put(loser3, 4);
                        }
                    }
                    for (i = 121; i <= 122; ++i) {
                        Match match3 = (Match)matches.get(i);
                        if (match3.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match3, (Set)matchPoints.get(match3.getFightNumber()))) == null) continue;
                        placings.put(loser3, 5);
                    }
                } else {
                    for (i = 121; i <= 122; ++i) {
                        Match match4 = (Match)matches.get(i);
                        if (match4.getStatus() == Match.Status.FINISHED) {
                            Competitor loser5;
                            Competitor winner2 = competitionRules.getMatchWinner(match4, (Set)matchPoints.get(match4.getFightNumber()));
                            if (winner2 != null) {
                                placings.put(winner2, 3);
                            }
                            if ((loser5 = competitionRules.getMatchLoser(match4, (Set)matchPoints.get(match4.getFightNumber()))) == null) continue;
                            placings.put(loser5, 5);
                            continue;
                        }
                        if (!match4.getNotNeeded().booleanValue()) continue;
                        if (match4.getCompetitor1() == null && match4.getCompetitor2() == null) {
                            treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                            treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                            if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                                Match looserMatch22 = (Match)matches.get(treeAdvancmentItem1.getFromMatch());
                                Competitor loser22 = competitionRules.getMatchLoser(looserMatch22, (Set)matchPoints.get(looserMatch22.getFightNumber()));
                                if (loser22 == null) continue;
                                placings.put(loser22, 3);
                                continue;
                            }
                            if (treeAdvancmentItem2.getSelectType() != SelectType.LOSER || (loser2 = competitionRules.getMatchLoser(looserMatch2 = (Match)matches.get(treeAdvancmentItem2.getFromMatch()), (Set)matchPoints.get(looserMatch2.getFightNumber()))) == null) continue;
                            placings.put(loser2, 3);
                            continue;
                        }
                        if (match4.getCompetitor1() != null && match4.getCompetitor2() != null) continue;
                        Competitor winner2 = match4.getCompetitor1();
                        if (winner2 == null) {
                            winner2 = match4.getCompetitor2();
                        }
                        if (winner2 == null) continue;
                        placings.put(winner2, 3);
                    }
                }
                for (i = 119; i <= 120; ++i) {
                    Match match5 = (Match)matches.get(i);
                    if (match5.getNotNeeded().booleanValue() && match5.getCompetitor1() == null && match5.getCompetitor2() == null) {
                        treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner1 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner2 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner3 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner4 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        if (treeAdvancmentItemWinner1.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner1.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 5);
                        }
                        if (treeAdvancmentItemWinner2.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner2.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 5);
                        }
                        if (treeAdvancmentItemWinner3.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner3.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 5);
                        }
                        if (treeAdvancmentItemWinner4.getSelectType() != SelectType.LOSER || (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner4.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) == null) continue;
                        placings.put(loser, 5);
                        continue;
                    }
                    if (match5.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match5, (Set)matchPoints.get(match5.getFightNumber()))) == null) continue;
                    placings.put(loser3, 7);
                }
                for (i = 113; i <= 116; ++i) {
                    Match match6 = (Match)matches.get(i);
                    if (match6.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match6, (Set)matchPoints.get(match6.getFightNumber()))) == null) continue;
                    placings.put(loser3, 9);
                }
                for (i = 109; i <= 112; ++i) {
                    Match match7 = (Match)matches.get(i);
                    if (match7.getNotNeeded().booleanValue() && match7.getCompetitor1() == null && match7.getCompetitor2() == null) {
                        treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner1 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner2 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner3 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner4 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        if (treeAdvancmentItemWinner1.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner1.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 9);
                        }
                        if (treeAdvancmentItemWinner2.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner2.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 9);
                        }
                        if (treeAdvancmentItemWinner3.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner3.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 9);
                        }
                        if (treeAdvancmentItemWinner4.getSelectType() != SelectType.LOSER || (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner4.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) == null) continue;
                        placings.put(loser, 9);
                        continue;
                    }
                    if (match7.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match7, (Set)matchPoints.get(match7.getFightNumber()))) == null) continue;
                    placings.put(loser3, 13);
                }
                for (i = 97; i <= 104; ++i) {
                    Match match8 = (Match)matches.get(i);
                    if (match8.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match8, (Set)matchPoints.get(match8.getFightNumber()))) == null) continue;
                    placings.put(loser3, 17);
                }
                for (i = 89; i <= 96; ++i) {
                    Match match9 = (Match)matches.get(i);
                    if (match9.getNotNeeded().booleanValue() && match9.getCompetitor1() == null && match9.getCompetitor2() == null) {
                        treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner1 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner2 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem1.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        treeAdvancmentItemWinner3 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItemWinner4 = treeAdvancment.getTreeAdvancmentItem(treeAdvancmentItem2.getFromMatch().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                        if (treeAdvancmentItemWinner1.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner1.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 17);
                        }
                        if (treeAdvancmentItemWinner2.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner2.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 17);
                        }
                        if (treeAdvancmentItemWinner3.getSelectType() == SelectType.LOSER && (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner3.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) != null) {
                            placings.put(loser, 17);
                        }
                        if (treeAdvancmentItemWinner4.getSelectType() != SelectType.LOSER || (loser = competitionRules.getMatchLoser(looserMatch = (Match)matches.get(treeAdvancmentItemWinner4.getFromMatch()), (Set)matchPoints.get(looserMatch.getFightNumber()))) == null) continue;
                        placings.put(loser, 17);
                        continue;
                    }
                    if (match9.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match9, (Set)matchPoints.get(match9.getFightNumber()))) == null) continue;
                    placings.put(loser3, 25);
                }
                for (i = 65; i <= 80; ++i) {
                    Match match10 = (Match)matches.get(i);
                    if (match10.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match10, (Set)matchPoints.get(match10.getFightNumber()))) == null) continue;
                    placings.put(loser3, 33);
                }
                for (i = 49; i <= 64; ++i) {
                    Match match11 = (Match)matches.get(i);
                    if (match11.getNotNeeded().booleanValue() && match11.getCompetitor1() == null && match11.getCompetitor2() == null) {
                        treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                        treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                        if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                            looserMatch2 = (Match)matches.get(treeAdvancmentItem1.getFromMatch());
                            loser2 = competitionRules.getMatchLoser(looserMatch2, (Set)matchPoints.get(looserMatch2.getFightNumber()));
                            if (loser2 == null) continue;
                            placings.put(loser2, 33);
                            continue;
                        }
                        if (treeAdvancmentItem2.getSelectType() != SelectType.LOSER || (loser2 = competitionRules.getMatchLoser(looserMatch2 = (Match)matches.get(treeAdvancmentItem2.getFromMatch()), (Set)matchPoints.get(looserMatch2.getFightNumber()))) == null) continue;
                        placings.put(loser2, 33);
                        continue;
                    }
                    if (match11.getStatus() != Match.Status.FINISHED || (loser3 = competitionRules.getMatchLoser(match11, (Set)matchPoints.get(match11.getFightNumber()))) == null) continue;
                    placings.put(loser3, 49);
                }
            }
            return placings;
        }
        catch (Exception e) {
            log.error("Error while calcuating placings for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match addMatch(Category category, Match match) {
        if (category == null || category.getCategoryId() == null) {
            return null;
        }
        if (match == null) {
            return null;
        }
        this.lockCategory(category);
        category = this.categoryManager.getById(category.getCategoryId());
        if (log.isDebugEnabled()) {
            log.debug("Adding match {} to category", (Object)match, (Object)category);
        }
        try {
            if (category.getType() != Category.Type.CUSTOM) {
                throw new RuntimeException("Category is not CUSTOM type");
            }
            int fightNumber = 1;
            for (Match m : this.matchManager.getMatchesForCategory(category)) {
                if (fightNumber > m.getFightNumber()) continue;
                fightNumber = m.getFightNumber() + 1;
            }
            match.setCategory(category);
            match.setFightNumber(Integer.valueOf(fightNumber));
            match = this.matchManager.createMatch(match);
        }
        catch (Throwable e) {
            log.error("Error while adding match to category " + category.toString(), e);
        }
        finally {
            this.unlockCategory(category);
        }
        return match;
    }

    private void lockCategory(Category category) {
        Lock lock = this.lockService.getLockByName("category.update." + category.getCategoryId());
        lock.lock();
    }

    private void unlockCategory(Category category) {
        Lock lock = this.lockService.getLockByName("category.update." + category.getCategoryId());
        lock.unlock();
    }
}

