/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dl.dao.AgeCategoryOptionDAO;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;

public class AgeCategoryOptionManagerImpl
implements AgeCategoryOptionManager {
    private static final Logger log = LoggerFactory.getLogger(AgeCategoryOptionManagerImpl.class);
    private AgeCategoryOptionDAO ageCategoryOptionDAO;

    public void setAgeCategoryOptionDAO(AgeCategoryOptionDAO ageCategoryOptionDAO) {
        this.ageCategoryOptionDAO = ageCategoryOptionDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption createAgeCategoryOption(AgeCategoryOption ageCategoryOption) {
        if (log.isDebugEnabled()) {
            log.debug("Creating age category option {}", (Object)ageCategoryOption);
        }
        return (AgeCategoryOption)this.ageCategoryOptionDAO.create((Pojo)ageCategoryOption);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption updateAgeCategoryOption(AgeCategoryOption ageCategoryOption) {
        if (log.isDebugEnabled()) {
            log.debug("Updating age category option {}", (Object)ageCategoryOption);
        }
        return (AgeCategoryOption)this.ageCategoryOptionDAO.update((Pojo)ageCategoryOption);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getById(Long ageCategoryOptionId) {
        return (AgeCategoryOption)this.ageCategoryOptionDAO.getById((Object)ageCategoryOptionId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Page<AgeCategoryOption> find(Page<AgeCategoryOption> page) {
        return this.ageCategoryOptionDAO.find(page, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getForCategory(FightingCategory fightingCategory) {
        return this.ageCategoryOptionDAO.getForCategory(fightingCategory);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getForCategory(DuoCategory duoCategory) {
        return this.ageCategoryOptionDAO.getForCategory(duoCategory);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getForCategory(NewazaCategory newazaCategory) {
        return this.ageCategoryOptionDAO.getForCategory(newazaCategory);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getActiveAgeCategoryOptionByName(String name) {
        return this.ageCategoryOptionDAO.getAgeCategoryOptionByName(name, true);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AgeCategoryOption getAgeCategoryOptionByName(String name) {
        return this.ageCategoryOptionDAO.getAgeCategoryOptionByName(name, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<AgeCategoryOption> getActiveAgeCategoriesForCompetitions(Competition competition) {
        return this.ageCategoryOptionDAO.getActiveAgeCategoriesForCompetitions(competition);
    }
}

