/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.textrenderer.velocity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.textrenderer.velocity.MessageLoader;

public class ClasspathMessageLoader
implements MessageLoader {
    private static final Logger log = LoggerFactory.getLogger(ClasspathMessageLoader.class);
    private String baseName;
    private Map<Locale, ResourceBundle> boundles = new HashMap<Locale, ResourceBundle>();

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String getMessage(String key, Locale locale) {
        return this.getMessage(key, locale, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String key, Locale locale, Object[] args) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Map<Locale, ResourceBundle> map = this.boundles;
            synchronized (map) {
                if (!this.boundles.containsKey(locale)) {
                    try {
                        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.baseName, locale);
                        if (resourceBundle != null) {
                            this.boundles.put(locale, resourceBundle);
                        }
                    }
                    catch (MissingResourceException e) {
                        log.warn("Messages not found for locale {}", (Object)locale.getDisplayName());
                    }
                }
            }
            ResourceBundle resourceBundle = this.boundles.get(locale);
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                String text = resourceBundle.getString(key);
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        text = text.replaceAll("\\{" + i + "\\}", args[i] == null ? "null" : args[i].toString());
                    }
                }
                return text;
            }
            return key;
        }
        catch (Exception e) {
            log.error("Error while getting message for key " + key);
            return key;
        }
    }

    @Override
    public String getMessage(String key, Locale locale, List<?> args) {
        Object[] argsList = args == null ? null : args.toArray();
        return this.getMessage(key, locale, argsList);
    }
}

