/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessenger;
import si.nevensrok.common.network.tcp.DisconnectListener;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;

public class TcpNetworkClient
implements NetworkMessenger,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkClient.class);
    private boolean active = false;
    private String address;
    private Integer port;
    private int connectTimeout = 10000;
    private int reconnectTimeout = 3000;
    private Object connectedMonitor = new Object();
    private boolean isConnected = false;
    private TcpNetworkConnection tcpNetworkConnection = null;
    private boolean reconnecting = false;
    private Object reconnectingMonitor = new Object();
    private Object messageMonitor = new Object();
    private LinkedList<NetworkMessage> messages = new LinkedList();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnecting(boolean reconnecting) {
        this.reconnecting = reconnecting;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.address == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        this.active = true;
        this.reconnect();
    }

    protected Socket openSocket() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(this.address, (int)this.port);
        Socket socket = new Socket();
        socket.connect(socketAddress, this.connectTimeout);
        return socket;
    }

    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        return new TcpNetworkConnection(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        Object object = this.reconnectingMonitor;
        synchronized (object) {
            if (!this.active) {
                return;
            }
            if (this.tcpNetworkConnection != null) {
                return;
            }
            if (this.reconnecting) {
                return;
            }
            this.reconnecting = true;
            Thread reconnectThread = new Thread("Reconnect thread for " + this.address + ":" + this.port){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (TcpNetworkClient.this.active) {
                        Socket socket = null;
                        try {
                            log.debug("Connecting to {}:{}", (Object)TcpNetworkClient.this.address, (Object)TcpNetworkClient.this.port);
                            socket = TcpNetworkClient.this.openSocket();
                            TcpNetworkClient.this.tcpNetworkConnection = TcpNetworkClient.this.openTcpNetworkConnection(socket);
                            TcpNetworkClient.this.tcpNetworkConnection.open();
                            TcpNetworkClient.this.tcpNetworkConnection.setDisconnectListener(new DisconnectListener(){

                                @Override
                                public void disconnected(TcpNetworkConnection nc) {
                                    TcpNetworkClient.this.tcpNetworkConnection = null;
                                    TcpNetworkClient.this.isConnected = false;
                                    TcpNetworkClient.this.reconnect();
                                }
                            });
                            if (log.isDebugEnabled()) {
                                log.debug("Connected from {}:{} to {}:{}", new Object[]{socket.getLocalAddress().getHostAddress(), socket.getLocalPort(), socket.getInetAddress().getHostAddress(), socket.getPort()});
                            }
                            TcpNetworkClient.this.reconnecting = false;
                            Thread thread = new Thread("Message receive thread for socket " + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort()){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    while (true) {
                                        try {
                                            while (true) {
                                                NetworkMessage networkMessage = TcpNetworkClient.this.tcpNetworkConnection.receiveMessage();
                                                Object object = TcpNetworkClient.this.messageMonitor;
                                                synchronized (object) {
                                                    TcpNetworkClient.this.messages.add(networkMessage);
                                                    TcpNetworkClient.this.messageMonitor.notifyAll();
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            log.trace("Error receiving message", (Throwable)e);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            };
                            thread.setDaemon(true);
                            thread.start();
                            Object object = TcpNetworkClient.this.connectedMonitor;
                            synchronized (object) {
                                TcpNetworkClient.this.isConnected = true;
                                TcpNetworkClient.this.connectedMonitor.notifyAll();
                                break;
                            }
                        }
                        catch (Throwable e) {
                            try {
                                socket.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            log.debug("Error connection to " + TcpNetworkClient.this.address + ":" + TcpNetworkClient.this.port, e);
                            try {
                                Thread.sleep(TcpNetworkClient.this.reconnectTimeout);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            };
            reconnectThread.setDaemon(true);
            reconnectThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from {}:{}", (Object)this.address, (Object)this.port);
        }
        this.active = false;
        this.isConnected = false;
        try {
            this.tcpNetworkConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.messageMonitor;
        synchronized (object) {
            this.messages.clear();
            this.messageMonitor.notifyAll();
        }
        object = this.connectedMonitor;
        synchronized (object) {
            this.connectedMonitor.notifyAll();
        }
    }

    @Override
    public void sendMessage(Object object) throws NetworkException {
        if (this.tcpNetworkConnection == null) {
            throw new NetworkException("Not connected");
        }
        try {
            this.tcpNetworkConnection.sendMessage(object);
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkMessage receiveMessage() throws NetworkException {
        Object object = this.messageMonitor;
        synchronized (object) {
            while (this.messages.isEmpty() && this.active) {
                try {
                    this.messageMonitor.wait();
                }
                catch (Exception exception) {}
            }
            if (this.messages.isEmpty()) {
                throw new NetworkException("Connection closed");
            }
            return this.messages.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForConnection(long waitTime) {
        if (!this.active) {
            return false;
        }
        Object object = this.connectedMonitor;
        synchronized (object) {
            if (!this.isConnected && this.active) {
                try {
                    this.connectedMonitor.wait(waitTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.isConnected && this.active;
        }
    }
}

