/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import si.nevensrok.common.jms.MessageHandler;

public class JmsProcessorInstance
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(JmsProcessorInstance.class);
    private static final boolean transacted = false;
    private static final int acknowledgeMode = 1;
    private TaskExecutor taskExecutor;
    private MessageHandler messageHandler;
    private Session session;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;

    public JmsProcessorInstance(Connection connection, int deliveryMode, int priority, int timeToLive, TaskExecutor taskExecutor, String source, MessageHandler messageHandler) throws Exception {
        this.taskExecutor = taskExecutor;
        this.messageHandler = messageHandler;
        this.session = connection.createSession(false, 1);
        Queue queue = this.session.createQueue(source);
        this.messageProducer = this.session.createProducer(null);
        this.messageProducer.setDeliveryMode(deliveryMode);
        if (priority > 0) {
            this.messageProducer.setPriority(priority);
        }
        if (timeToLive > 0) {
            this.messageProducer.setTimeToLive((long)timeToLive);
        }
        this.messageConsumer = this.session.createConsumer((Destination)queue);
        this.messageConsumer.setMessageListener((MessageListener)this);
    }

    public void close() {
        try {
            this.messageConsumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.messageProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessage(final Message message) {
        try {
            log.trace("JMS message received: {}", (Object)message);
            final String correlationId = message.getJMSCorrelationID();
            if (correlationId == null || correlationId.isEmpty()) {
                throw new RuntimeException("CorrelationId not present");
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Message responseMessage = JmsProcessorInstance.this.messageHandler.handleMessage(JmsProcessorInstance.this.session, message);
                        responseMessage.setJMSCorrelationID(correlationId);
                        JmsProcessorInstance.this.messageProducer.send(message.getJMSReplyTo(), responseMessage);
                    }
                    catch (Exception e) {
                        log.trace("Error handling message", (Throwable)e);
                        throw new RuntimeException("Error handling message");
                    }
                }
            };
            if (this.taskExecutor != null) {
                this.taskExecutor.execute(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            log.trace("Error handling message", (Throwable)e);
            throw new RuntimeException("Error handling message");
        }
    }
}

