/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessageSender;
import si.nevensrok.common.utils.ObjectUtil;

public class UdpMessageSender
implements NetworkMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UdpMessageSender.class);
    private String address;
    private Integer port;
    private DatagramSocket socket = null;
    private Object senderMonitor = new Object();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.address == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        if (log.isDebugEnabled()) {
            log.debug("Connecting to UDP on address {}:{}", (Object)this.address, (Object)this.port);
        }
        try {
            this.socket = new DatagramSocket();
            this.socket.connect(InetAddress.getByName(this.address), this.port);
        }
        catch (Exception e) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to broadcast", e);
        }
    }

    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from UDP on address {}:{}", (Object)this.address, (Object)this.port);
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Object object) throws NetworkException {
        try {
            byte[] data = ObjectUtil.serializeObject(object);
            DatagramPacket packet = new DatagramPacket(data, data.length);
            if (log.isTraceEnabled()) {
                log.trace("Sending message to {}:{}, message data: {}", new Object[]{this.address, this.port, data});
            }
            Object object2 = this.senderMonitor;
            synchronized (object2) {
                this.socket.send(packet);
            }
        }
        catch (Exception e) {
            throw new NetworkException("Error sending message", e);
        }
    }
}

