/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import si.nevensrok.common.jms.JmsProcessorInstance;
import si.nevensrok.common.jms.MessageHandler;

public class JmsMessageProcessor
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsMessageProcessor.class);
    private ConnectionFactory connectionFactory;
    private String source;
    private MessageHandler messageHandler;
    private int deliveryMode = 1;
    private int priority = -1;
    private int timeToLive = -1;
    private int consumers = 1;
    private TaskExecutor taskExecutor = null;
    private Connection connection;
    private JmsProcessorInstance[] jmsProcessorInstances;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setConsumers(int consumers) {
        this.consumers = consumers;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Initializing message processor");
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.source == null) {
            throw new IllegalArgumentException("Property 'source' is required");
        }
        if (this.messageHandler == null) {
            throw new IllegalArgumentException("Property 'messageHandler' is required");
        }
        if (this.consumers < 1) {
            throw new IllegalArgumentException("Property 'consumers' must be higher that 0");
        }
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.jmsProcessorInstances = new JmsProcessorInstance[this.consumers];
        for (int i = 0; i < this.consumers; ++i) {
            this.jmsProcessorInstances[i] = new JmsProcessorInstance(this.connection, this.deliveryMode, this.priority, this.timeToLive, this.taskExecutor, this.source, this.messageHandler);
        }
    }

    public void destroy() throws Exception {
        log.debug("Closing message processor");
        try {
            for (int i = 0; i < this.jmsProcessorInstances.length; ++i) {
                try {
                    this.jmsProcessorInstances[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

