/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.net.URI;
import java.util.LinkedList;
import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.tcp.TcpCacheLoader;
import si.nevensrok.common.network.tcp.SslTcpNetworkClient;
import si.nevensrok.common.network.tcp.TcpNetworkClient;

public class TcpCacheLoaderFactory
extends CacheLoaderFactory {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheLoaderFactory.class);

    public CacheLoader createCacheLoader(Ehcache cache, Properties properties) {
        try {
            String[] providerUrls;
            LinkedList<TcpNetworkClient> tcpNetworkClients = new LinkedList<TcpNetworkClient>();
            for (String providerUrl : providerUrls = PropertyUtil.extractAndLogProperty((String)"providerURL", (Properties)properties).split("\\x7C")) {
                URI uri = new URI(providerUrl);
                String address = uri.getHost();
                int port = uri.getPort();
                TcpNetworkClient tcpNetworkClient = null;
                tcpNetworkClient = providerUrl.toLowerCase().startsWith("ssl://") ? new SslTcpNetworkClient() : new TcpNetworkClient();
                tcpNetworkClient.setAddress(address);
                tcpNetworkClient.setPort(port);
                tcpNetworkClients.add(tcpNetworkClient);
            }
            return new TcpCacheLoader(cache, tcpNetworkClients);
        }
        catch (Exception e) {
            log.error("Error creating tcp cache loader", (Throwable)e);
            return null;
        }
    }
}

