/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.captcha.simple;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nl.captcha.noise.NoiseProducer;

public class RandomPixelNoiseProducer
implements NoiseProducer {
    private Random random = new Random();
    private List<Color> colors;

    public RandomPixelNoiseProducer() {
        this(Color.BLACK);
    }

    public RandomPixelNoiseProducer(Color color) {
        this.colors = new ArrayList<Color>(1);
        this.colors.add(color);
    }

    public RandomPixelNoiseProducer(List<Color> colors) {
        this.colors = colors;
    }

    public void makeNoise(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int numberOfPixels = Math.round((float)(width * height) * 0.25f);
        for (int i = 0; i < numberOfPixels; ++i) {
            int x = this.random.nextInt(width);
            int y = this.random.nextInt(height);
            int rgb = -16777216 + this.colors.get(this.random.nextInt(this.colors.size())).getRGB();
            image.setRGB(x, y, rgb);
        }
    }
}

