(function() {
	var fullIpponPoints=50;
	var newazaFinishingMovePoints=100;
	
	/*------------ Messages ------------*/
	function showInfoMessage(text) {
		$("#message-area").html(Mustache.render("<div class=\"alert alert-info\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",{"text":text}));
	}
	
	function showSuccessMessage(text) {
		$("#message-area").html(Mustache.render("<div class=\"alert alert-success\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",{"text":text}));
	}
	
	function showErrorMessage(text) {
		$("#message-area").html(Mustache.render("<div class=\"alert alert-danger\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",{"text":text}));
	}
	
	/*-------- Display settings------*/
	var DisplaySettings=Backbone.Model.extend({
		"defaults": {
			"category":null,
			"type":"",
			"tatami":null
		}
	});
	
	var displaySettings=new DisplaySettings();
	
	/*-------- Functions--------*/
	function reloadData() {
		displaySettings.trigger("change:tatami");
		displaySettings.trigger("change:category");
	}
	
	/*----- Competitors ---------*/
	var CompetitorModel=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"name":"",
			"shortName":"",
			"clubId":0,
			"clubName":"",
			"shortClubName":"",
			"type":"",
			"draw":0
		}
	});
	
	var CompetitorCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/competitor"; },
		"model":CompetitorModel
	});
	
	/*-------- Event -------*/
	var EventModel=Backbone.Model.extend({
		"url":function() { return contextPath+"/competition/data/event"; },
		"defaults": {
			"id":null,
			"text":"",
			"autoRemove":false
		}
	});
	
	var EventEditView=Backbone.View.extend({
		"tagName":"div",
		"template":templates.getCompetitionEditEventTemplate(),
		"initialize":function() {
			$(this.el).attr("class","modal fade");
			
			var obj=this;
			
			this.on("show",function() {
				$("body").append(obj.el);
				
				$(obj.el).modal({
			    	show:false
			    });
			    
				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});
				
				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj=this;
			
			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));
			
			$(".btn-primary", this.el).on("click",function() {
				obj.model.set("text",$("textarea[name='event-text']", obj.el).val());
				obj.model.set("autoRemove",$("input[name='autoRemove']", obj.el).is(":checked"));
				
				var url=obj.model.url()+"?tatamiId="+displaySettings.get("tatami").get("id");
				if (obj.model.get("id")!=null) {
					url=obj.model.url()+"?eventId="+obj.model.get("id");
				}
				
				$.ajax({
					"async":false,
					"url":url,
					"type":"POST",
					"contentType": "application/json; charset=utf-8",
					"data":JSON.stringify(obj.model.toJSON())
				});
				$(obj.el).modal("hide");
				
				reloadData();
			});
			
			return this;
		}
	});
	
	/*--------- Placings ----------*/
	var PlacingModel=Backbone.Model.extend({
		"defaults": {
			"place":0,
			"competitor":null
		}
	});
	
	var PlacingCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/placings"; },
		"model":PlacingModel
	});
	
	var PlacingView=Backbone.View.extend({
		"template":templates.getCompetitionPlacingsTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			var data={
				"placings":this.collection.toJSON()
			};
			$(this.el).html(Mustache.render(this.template,data));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			return this;
		}
	});
	
	/*--------- Matches ---------*/
	var FightPoints=Backbone.Model.extend({
		"url":function() { return contextPath+"/competition/data/fight-points"; },
		"defaults": {
			"competitor1":"",
			"club1":"",
			"wazari1":0,
			"ippon1_1":0,
			"ippon1_2":0,
			"ippon1_3":0,
			"ippon1_3p":0,
			"shido1":0,
			"chui1":0,
			"hansokumake1":0,
			"competitor2":"",
			"club2":"",
			"wazari2":0,
			"ippon2_1":0,
			"ippon2_2":0,
			"ippon2_3":0,
			"ippon2_3p":0,
			"shido2":0,
			"chui2":0,
			"hansokumake2":0,
			"noWinner":false,
			"finished":false,
			"matchTime":null,
			"hosekomiTime":null,
			"injuryTime1":null,
			"injuryTime2":null
		}
	});
	
	var DuoPoints=Backbone.Model.extend({
		"url":function() { return contextPath+"/competition/data/duo-points"; },
		"defaults": {
			"competitor1":"",
			"club1":"",
			"rounds1":null,
			"competitor2":"",
			"club2":"",
			"rounds2":null,
			"noWinner":false,
			"finished":false,
			"injuryTime1":null,
			"injuryTime2":null
		}
	});
	
	var NewazaPoints=Backbone.Model.extend({
		"url":function() { return contextPath+"/competition/data/newaza-points"; },
		"defaults": {
			"competitor1":"",
			"club1":"",
			"point1_1":0,
			"point1_2":0,
			"point1_3":0,
			"point1_4":0,
			"point1_5":0,
			"point1_6":0,
			"point1_7":0,
			"advantage1":0,
			"finishingMove1":0,
			"shido1":0,
			"hansokumake1":0,
			"competitor2":"",
			"club2":"",
			"point2_1":0,
			"point2_2":0,
			"point2_3":0,
			"point2_4":0,
			"point2_5":0,
			"point2_6":0,
			"point2_7":0,
			"advantage2":0,
			"finishingMove2":0,
			"shido2":0,
			"hansokumake2":0,
			"noWinner":false,
			"finished":false,
			"matchTime":null,
			"hosekomiTime":null,
			"injuryTime1":null,
			"injuryTime2":null
		}
	});
	
	var MatchModel=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"number":0,
			"name":"",
			"shortName":"",
			"competitor1":null,
			"competitor2":null,
			"points1":0,
			"points2":0,
			"status":"",
			"type":"",
			"categoryName":"",
			"categoryShortName":"",
			"canRemove":false
		},
		"parse":function(response, options) {
			response.isNotNeeded=response.status=="NOTNEEDED";
			response.isWaiting=response.status=="WAITING";
			response.isInQueue=response.status=="INQUEUE";
			response.isInProgress=response.status=="INPROGRESS";
			response.isFinished=response.status=="FINISHED";
			response.canAdd=response.isWaiting;
			return response;
		}
	});
	
	var MatchCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/match"; },
		"model":MatchModel
	});
	
	var MatchDetailsView=Backbone.View.extend({
		"tagName":"div",
		"template":templates.getCompetitionMatchDetailsTemplate(),
		"initialize":function() {
			$(this.el).attr("class","modal fade");
			
			var obj=this;
			
			this.on("show",function() {
				$("body").append(obj.el);
				
				$(obj.el).modal({
			    	show:false
			    });
			    
				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});
				
				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj=this;
			
			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));
			
			$.ajax({
				url:contextPath+"/competition/data/match-deatils/"+String(obj.model.get("id")),
				type: 'GET',
				success: function(responseData) {
					var chartType=responseData.chartType;
					var data=responseData.chartData;
					var categories=responseData.categories;
					var xAxisLabel=responseData.xAxisLabel;
					var yAxisLabel=responseData.yAxisLabel;
					var tooltipText=responseData.tooltipText;
					
					$("#match-points-graph").highcharts({
						chart: {
							type: chartType
						},
						title:{
							text:"",
							style: {
								display: 'none'
							}
						},
						xAxis:{
							title:{
								text:xAxisLabel
							},
							categories:categories
						},
						yAxis:{
							title:{
								text:yAxisLabel
							},
							min:0
						},
						colors: ['#AA4643', '#4572A7'],
						tooltip: {
							formatter: function() {
								var text=tooltipText;
								text=text.replace("%s",this.series.name);
								text=text.replace("%x",this.x);
								text=text.replace("%y",this.y);
								return text;
							}
						},
						credits: {
							enabled: false
						},
						series:data
					});
				}
			});
			
			return this;
		}
	});
	
	var MatchEditView=Backbone.View.extend({
		"tagName":"div",
		"fightTemplate":templates.getCompetitionEditMatchFightTemplate(),
		"duoTemplate":templates.getCompetitionEditMatchDuoTemplate(),
		"newazaTemplate":templates.getCompetitionEditMatchNewazaTemplate(),
		"initialize":function() {
			$(this.el).attr("class","modal fade");
			
			var obj=this;
			
			this.on("show",function() {
				$("body").append(obj.el);
				
				$(obj.el).modal({
			    	show:false
			    });
			    
				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});
				
				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj=this;
			
			if (this.model.match.get("type")=="FIGHT") {
				$(this.el).html(Mustache.render(this.fightTemplate,this.model.points.toJSON()));
				
				function calculateFightPointsSum() {
					if (Number($("input[name='hansokumake1']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(fullIpponPoints);
					}
					else if (Number($("input[name='hansokumake2']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val(fullIpponPoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='ippon1_1']",obj.el).val())>0
							&& Number($("input[name='ippon1_2']",obj.el).val())>0
							&& (Number($("input[name='ippon1_3']",obj.el).val())>0 || Number($("input[name='ippon1_3p']",obj.el).val())>0)) {
						$("input[name='sum1']",obj.el).val(fullIpponPoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='ippon2_1']",obj.el).val())>0
							&& Number($("input[name='ippon2_2']",obj.el).val())>0
							&& (Number($("input[name='ippon2_3']",obj.el).val())>0 || Number($("input[name='ippon2_3p']",obj.el).val())>0)) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(fullIpponPoints);
					}
					else {
						var sum1=Number($("input[name='wazari1']",obj.el).val())
									+ Number($("input[name='ippon1_1']",obj.el).val())*2
									+ Number($("input[name='ippon1_2']",obj.el).val())*2
									+ Number($("input[name='ippon1_3']",obj.el).val())*2
									+ Number($("input[name='ippon1_3p']",obj.el).val())*3;
						var sum2=Number($("input[name='wazari2']",obj.el).val())
									+ Number($("input[name='ippon2_1']",obj.el).val())*2
									+ Number($("input[name='ippon2_2']",obj.el).val())*2
									+ Number($("input[name='ippon2_3']",obj.el).val())*2
									+ Number($("input[name='ippon2_3p']",obj.el).val())*3;
						
						$("input[name='sum1']",obj.el).val(sum1);
						$("input[name='sum2']",obj.el).val(sum2);
					}
				}
				
				$("input.fightPointsInput", this.el).on("change",function() {
					calculateFightPointsSum();
				});
				
				calculateFightPointsSum();
				
				$("input.fightPointsInput", this.el).spinner({
					"min":0,
					"change":function() {
						calculateFightPointsSum();
					},
					"stop":function() {
						calculateFightPointsSum();
					}
				});
			}
			else if (this.model.match.get("type")=="DUO") {
				$(this.el).html(Mustache.render(this.duoTemplate,this.model.points.toJSON()));
				
				function calculateDuoPointsSum() {
					var sum1=0;
					var sum2=0;
					for (var round=1;round<=5;round++) {
						var roundSum1=0;
						var roundSum2=0;
						var min1=Number.MAX_VALUE;
						var max1=0;
						var min2=Number.MAX_VALUE;
						var max2=0;
						for (var judge=1;judge<=5;judge++) {
							var points1=Number($("[competitor='1'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							var points2=Number($("[competitor='2'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							roundSum1+=points1;
							roundSum2+=points2;
							
							if (points1>max1) {
								max1=points1;
							}
							if (points1<min1) {
								min1=points1;
							}
							if (points2>max2) {
								max2=points2;
							}
							if (points2<min2) {
								min2=points2;
							}
						}
						roundSum1-=min1+max1;
						roundSum2-=min2+max2;
						
						sum1+=roundSum1;
						sum2+=roundSum2;
						$("[competitor='1'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum1));
						$("[competitor='2'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum2));
					}
					$("[competitor='1'] input.fightPointsSummaryInput", obj.el).val(String(sum1));
					$("[competitor='2'] input.fightPointsSummaryInput", obj.el).val(String(sum2));
				}
				
				$("input.duoPointsInput", this.el).on("change",function() {
					calculateDuoPointsSum();
				});
				
				calculateDuoPointsSum();
			}
			else if (this.model.match.get("type")=="NEWAZA") {
				$(this.el).html(Mustache.render(this.newazaTemplate,this.model.points.toJSON()));
				
				function calculateNewazaPointsSum() {
					if (Number($("input[name='hansokumake1']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(newazaFinishingMovePoints);
					}
					else if (Number($("input[name='hansokumake2']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val(newazaFinishingMovePoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='finishingMove1']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val(newazaFinishingMovePoints);
						$("input[name='sum2']",obj.el).val("0");
					}
					else if (Number($("input[name='finishingMove2']",obj.el).val())>0) {
						$("input[name='sum1']",obj.el).val("0");
						$("input[name='sum2']",obj.el).val(newazaFinishingMovePoints);
					}
					else {
						var sum1=Number($("input[name='point1_1']",obj.el).val())
									+ Number($("input[name='point1_2']",obj.el).val())*2
									+ Number($("input[name='point1_3']",obj.el).val())*3
									+ Number($("input[name='point1_4']",obj.el).val())*4
									+ Number($("input[name='point1_5']",obj.el).val())*5
									+ Number($("input[name='point1_6']",obj.el).val())*6
									+ Number($("input[name='point1_7']",obj.el).val())*7;
						
						var sum2=Number($("input[name='point2_1']",obj.el).val())
									+ Number($("input[name='point2_2']",obj.el).val())*2
									+ Number($("input[name='point2_3']",obj.el).val())*3
									+ Number($("input[name='point2_4']",obj.el).val())*4
									+ Number($("input[name='point2_5']",obj.el).val())*5
									+ Number($("input[name='point2_6']",obj.el).val())*6
									+ Number($("input[name='point2_7']",obj.el).val())*7;
						
						$("input[name='sum1']",obj.el).val(sum1);
						$("input[name='sum2']",obj.el).val(sum2);
					}
				}
				
				$("input.newazaPointsInput", this.el).on("change",function() {
					calculateNewazaPointsSum();
				});
				
				calculateNewazaPointsSum();
				
				$("input.newazaPointsInput", this.el).spinner({
					"min":0,
					"change":function() {
						calculateNewazaPointsSum();
					},
					"stop":function() {
						calculateNewazaPointsSum();
					}
				});
			}
			
			$(".btn-primary", this.el).on("click",function() {
				if (obj.model.match.get("type")=="FIGHT") {
					$("input.fightPointsInput", obj.el).each(function(index, item) {
						var name=$(this).attr("name");
						var value=Math.round(Number($(this).val()));
						obj.model.points.set(name,value);
					});
					
					if ($("input[name='matchTime']", obj.el).val().length>0) {
						obj.model.points.set("matchTime",Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime",null);
					}
					
					if ($("input[name='hosekomiTime']", obj.el).val().length>0) {
						obj.model.points.set("hosekomiTime",Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime",null);
					}
				}
				else if (obj.model.match.get("type")=="DUO") {
					for (var round=1;round<=5;round++) {
						for (var judge=1;judge<=5;judge++) {
							var points1=Number($("[competitor='1'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							var points2=Number($("[competitor='2'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
							obj.model.points.get("rounds1")[round-1].judges[judge-1].points=points1;
							obj.model.points.get("rounds2")[round-1].judges[judge-1].points=points2;
						}
					}
				}
				else if (obj.model.match.get("type")=="NEWAZA") {
					$("input.newazaPointsInput", obj.el).each(function(index, item) {
						var name=$(this).attr("name");
						var value=Math.round(Number($(this).val()));
						obj.model.points.set(name,value);
					});
					
					if ($("input[name='matchTime']", obj.el).val().length>0) {
						obj.model.points.set("matchTime",Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime",null);
					}
					
					if ($("input[name='hosekomiTime']", obj.el).val().length>0) {
						obj.model.points.set("hosekomiTime",Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime",null);
					}
				}
				
				if ($("input[name='injuryTime1']", obj.el).val().length>0) {
					obj.model.points.set("injuryTime1",Math.round(Number($("input[name='injuryTime1']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime1",null);
				}
				if ($("input[name='injuryTime2']", obj.el).val().length>0) {
					obj.model.points.set("injuryTime2",Math.round(Number($("input[name='injuryTime2']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime2",null);
				}
				
				obj.model.points.set("noWinner",$("input[name='noWinner']", obj.el).is(":checked"));
				obj.model.points.set("finished",$("input[name='finished']", obj.el).is(":checked"));
				
				$.ajax({
					"async":false,
					"url":obj.model.points.url()+"?matchId="+obj.model.match.get("id"),
					"type":"POST",
					"contentType": "application/json; charset=utf-8",
					"data":JSON.stringify(obj.model.points.toJSON())
				});
				$(obj.el).modal("hide");
				reloadData();
			});
			
			return this;
		}
	});
	
	var MatchAddView=Backbone.View.extend({
		"tagName":"div",
		"template":templates.getCompetitionAddMatchTemplate(),
		"initialize":function() {
			$(this.el).attr("class","modal fade");
			
			var obj=this;
			
			this.on("show",function() {
				$("body").append(obj.el);
				
				$(obj.el).modal({
			    	show:false
			    });
			    
				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});
				
				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj=this;
			
			var competitorCollection=new CompetitorCollection();
			competitorCollection.fetch({
				"data": {
					"categoryId":displaySettings.get("category").get("id")
				},
				"async":false
			});
			
			var data={
				"competitors":competitorCollection.toJSON()
			};
			
			$(this.el).html(Mustache.render(this.template,data));
			
			$("[name='competitor1']", obj.el).chosen({
				"search_contains":true,
				"width":"250px"
			});
			
			$("[name='competitor2']", obj.el).chosen({
				"search_contains":true,
				"width":"250px"
			});
			
			$(".btn-primary", this.el).on("click",function() {
				var data={
					"competitor1id":Number($("[name='competitor1']", obj.el).val()),
					"competitor2id":Number($("[name='competitor2']", obj.el).val()),
					"type":$("[name='match-type']", obj.el).val()
				};
				
				$.ajax({
					"async":false,
					"url":contextPath+"/competition/data/add-match?categoryId="+displaySettings.get("category").get("id"),
					"type":"POST",
					"contentType": "application/json; charset=utf-8",
					"data":JSON.stringify(data)
				});
				$(obj.el).modal("hide");
				reloadData();
			});
			
			return this;
		}
	});
	
	var MatchView=Backbone.View.extend({
		"template":templates.getCompetitionMatchTemplate(),
		"className":"match",
		"initialize":function() {
			this.model.on("change",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			var obj=this;
			
			$(".detailsButton", this.el).on("click",function() {
				var matchDetailsView=new MatchDetailsView({
					"model":obj.model
				});
				matchDetailsView.trigger("show");
			});
			
			$(".editButton", this.el).on("click",function() {
				var editFightModel={
					"match":obj.model
				};
				if (obj.model.get("type")=="FIGHT") {
					editFightModel.points=new FightPoints();
					editFightModel.points.fetch({
						"data":{
							"matchId":obj.model.get("id")
						},
						"async":false
					});
				}
				else if (obj.model.get("type")=="DUO") {
					editFightModel.points=new DuoPoints();
					editFightModel.points.fetch({
						"data":{
							"matchId":obj.model.get("id")
						},
						"async":false
					});
				}
				else if (obj.model.get("type")=="NEWAZA") {
					editFightModel.points=new NewazaPoints();
					editFightModel.points.fetch({
						"data":{
							"matchId":obj.model.get("id")
						},
						"async":false
					});
				}
				
				var matchEditView=new MatchEditView({
					"model":editFightModel
				});
				matchEditView.trigger("show");
			});
			
			$(".addToTatamiButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/add-fight-to-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".removeButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/remove-match/"+String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			return this;
		}
	});
	
	var MatchesView=Backbone.View.extend({
		"template":templates.getCompetitionMatchesTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(this.template);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			displaySettings.get("category").fetch({
				"async":false
			});
			
			for (var i=1;i<=124;i++) {
				var match=this.collection.where({"number":i})[0];
				if (match.get("status")=="WAITING"
						|| match.get("status")=="INQUEUE"
						|| match.get("status")=="INPROGRESS"
						|| match.get("status")=="FINISHED") {
					
					var matchView=new MatchView({
						"model":match
					});
					$("#matches-div").append(matchView.render().el);
				}
			}
			
			return this;
		}
	});
	
	var CustomMatchesView=Backbone.View.extend({
		"template":templates.getCompetitionCustomMatchesTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(this.template);
			
			$(".addMatchButton", this.el).on("click",function() {
				var matchAddView=new MatchAddView();
				matchAddView.trigger("show");
			});
			
			$("[rel='tooltip']", this.el).tooltip();
			
			displaySettings.get("category").fetch({
				"async":false
			});
			
			this.collection.each(function(match, index) {
				if (match.get("status")=="WAITING"
						|| match.get("status")=="INQUEUE"
						|| match.get("status")=="INPROGRESS"
						|| match.get("status")=="FINISHED") {
					
					var matchView=new MatchView({
						"model":match
					});
					$("#matches-div").append(matchView.render().el);
				}
				
			},this);
			
			return this;
		}
	});
	
	/*---------- Tatami fight ----------*/
	var TatamiFightModel=Backbone.Model.extend({
		"defaults": {
			"fightNumber":0,
			"match":null,
			"event":null
		}
	});
	
	var TatamiFightCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/tatami-fights"; },
		"model":TatamiFightModel
	});
	
	var TatamiFightView=Backbone.View.extend({
		"template":templates.getCompetitionTatamiFightTemplate(),
		"className":"match",
		"initialize":function() {
			this.model.on("change",function() {
				this.render();
			},this);
		},
		"render":function() {
			var data=this.model.toJSON();
			data.fightOrderNumber=this.fightOrderNumber;
			
			data.fights=[];
			this.collection.each(function(item, index) {
				var text="";
				var match=item.get("match");
				var event=item.get("event");
				
				if (match!=null) {
					if (match.competitor1!=null) {
						text+=match.competitor1.shortName;
					}
					if (match.competitor2!=null) {
						if (text.length>0) {
							text+="-";
						}
						text+=match.competitor2.shortName;
					}
				}
				else if (event!=null) {
					text=event.text;
				}
				
				var matchData={
					"number":index+1,
					"text":text
				};
				data.fights.push(matchData);
			});
			
			$(this.el).html(Mustache.render(this.template,data));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			var obj=this;
			
			$(".removeFightButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/remove-fight-to-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveFightUpButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/moveup-fight-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveFightDownButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/movedown-fight-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("match").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".editEventButton", this.el).on("click",function() {
				var eventModel=new EventModel();
				eventModel.fetch({
					"data":{
						"eventId":obj.model.get("event").id
					},
					"async":false
				});
				var eventEditView=new EventEditView({
					"model":eventModel
				});
				eventEditView.trigger("show");
			});
			
			$(".removeEventButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/remove-event-from-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveEventUpButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/moveup-event-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveEventDownButton", this.el).on("click",function() {
				$.ajax({
					url:contextPath+"/competition/data/movedown-event-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("event").id),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveFightToList a", this.el).on("click",function() {
				var moveTo=Number($(this).attr("href").substring(1));
				$.ajax({
					url:contextPath+"/competition/data/move-fight-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("match").id)+"/"+String(moveTo),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			$(".moveEventToList a", this.el).on("click",function() {
				var moveTo=Number($(this).attr("href").substring(1));
				$.ajax({
					url:contextPath+"/competition/data/move-event-tatami/"+String(displaySettings.get("tatami").get("id"))+"/"+String(obj.model.get("event").id)+"/"+String(moveTo),
					type: 'GET',
					success: function(responseData){
						reloadData();
					}
				});
			});
			
			return this;
		}
	});
	
	var TatamiFightsView=Backbone.View.extend({
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			var collection=this.collection;
			
			$(this.el).html("");
			
			this.collection.each(function(item, index) {
				var tatamiFightView=new TatamiFightView({
					"collection":collection,
					"model":item
				});
				tatamiFightView.fightOrderNumber=index+1;
				
				$(this.el).append(tatamiFightView.render().el);
			},this);
			
			return this;
		}
	});
	
	/*---------- Tatami history ----------*/
	var TatamiHistoryEventModel=Backbone.Model.extend({
		"defaults": {
			"eventDate":0,
			"eventDateText":"",
			"eventType":"",
			"match":null
		}
	});
	
	var TatamiHistoryEventCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/tatami-history"; },
		"model":TatamiHistoryEventModel
	});
	
	var TatamiHistoryEventView=Backbone.View.extend({
		"template":templates.getCompetitionTatamiHistoryEventTemplate(),
		"className":"tatami-history-event",
		"initialize":function() {
			this.model.on("change",function() {
				this.render();
			},this);
		},
		"render":function() {
			var data=this.model.toJSON();
			
			if (this.model.get("eventType")=="PULLMATCH") {
				data.icon="glyphicon glyphicon-arrow-up";
				data.iconTooltip=getSpringMessage("match.matchPulledTooltip");
			}
			else if (this.model.get("eventType")=="PUSHMATCH") {
				data.icon="glyphicon glyphicon-arrow-down";
				data.iconTooltip=getSpringMessage("match.matchPushedToolpip");
			}
			
			$(this.el).html(Mustache.render(this.template, data));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			return this;
		}
	});
	
	var TatamiHistoryEventsView=Backbone.View.extend({
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			var collection=this.collection;
			
			$(this.el).html("");
			
			this.collection.each(function(item, index) {
				var tatamiHistoryEventView=new TatamiHistoryEventView({
					"collection":collection,
					"model":item
				});
				
				$(this.el).append(tatamiHistoryEventView.render().el);
			},this);
			
			return this;
		}
	});
	
	/*--------- Tatamis ---------*/
	var TatamiModel=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"name":""
		}
	});
	
	var TatamiCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/tatami"; },
		"model":TatamiModel
	});
	
	var TatamiSelectView=Backbone.View.extend({
		"optionTemplate":"<option value=\"{{id}}\">{{name}}</option>",
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this).html("");
			
			var tatamis=this.collection;
			
			$(this.el).change(function() {
				var tatamiId=Number($(this).val());
				
				var tatami=tatamis.where({"id":tatamiId});
				if (tatami.length>0) {
					displaySettings.set("tatami",tatami[0]);
				}
			});
			
			this.collection.each(function(item, index) {
				$(this.el).append(Mustache.render(this.optionTemplate,item.toJSON()));
			},this);
			
			$(this.el).chosen({
				"search_contains":true,
				"width":"135px"
			});
			
			if (this.collection.length>0) {
				displaySettings.set("tatami",this.collection.at(0));
			}
			
			return this;
		}
	});
	
	/*--------- Tree ---------*/
	var TreeView=Backbone.View.extend({
		"template":templates.getCompetitionTreeTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(this.template);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TREE4") {
				$("#tree-div").attr("style","width:560px;height:330px;");
				for (var i=117;i<=118;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-117)*80+40)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=124;i<=124;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-124)*-80+80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i=123;i<=123;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-123)*-80+240)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
			}
			else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TREE8") {
				$("#tree-div").attr("style","width:770px;height:560px;");
				for (var i=105;i<=108;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-105)*80+40)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=117;i<=118;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-117)*160+80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=124;i<=124;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-124)*80+160)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i=119;i<=120;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-119)*80+390)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=121;i<=122;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-121)*80+390)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!displaySettings.get("category").get("treeCategoryOptions").double3rdPlace) {
					for (var i=123;i<=123;i++) {
						var match=this.collection.where({"number":i})[0];
						var matchView=new MatchView({
							"model":match,
							"attributes":{
								"style":"position:absolute;left:500px;top:"+String((i-123)*80+430)+"px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TREE16") {
				$("#tree-div").attr("style","width:1220px;height:1040px;");
				for (var i=81;i<=88;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-81)*80+40)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=105;i<=108;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-105)*160+80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=117;i<=118;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-117)*320+160)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=124;i<=124;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-124)*80+320)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i=109;i<=112;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-109)*80+700)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=113;i<=116;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-113)*80+700)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=119;i<=120;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-119)*160+740)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=121;i<=122;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-121)*160+740)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!displaySettings.get("category").get("treeCategoryOptions").double3rdPlace) {
					for (var i=123;i<=123;i++) {
						var match=this.collection.where({"number":i})[0];
						var matchView=new MatchView({
							"model":match,
							"attributes":{
								"style":"position:absolute;left:980px;top:"+String((i-123)*80+820)+"px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TREE32") {
				$("#tree-div").attr("style","width:1700px;height:2010px;");
				for (var i=33;i<=48;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-33)*80+40)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=81;i<=88;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-81)*160+80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=105;i<=108;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-105)*320+160)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=117;i<=118;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-117)*640+320)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=124;i<=124;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:980px;top:"+String((i-124)*80+640)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i=89;i<=96;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-89)*80+1360)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=97;i<=104;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-97)*80+1360)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=109;i<=112;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-109)*160+1400)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=113;i<=116;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-113)*160+1400)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=119;i<=120;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:980px;top:"+String((i-119)*320+1480)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=121;i<=122;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:1220px;top:"+String((i-121)*320+1480)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!displaySettings.get("category").get("treeCategoryOptions").double3rdPlace) {
					for (var i=123;i<=123;i++) {
						var match=this.collection.where({"number":i})[0];
						var matchView=new MatchView({
							"model":match,
							"attributes":{
								"style":"position:absolute;left:1460px;top:"+String((i-123)*80+1650)+"px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TREE64") {
				$("#tree-div").attr("style","width:2200px;height:3960px;");
				for (var i=1;i<=32;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-1)*80+40)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=33;i<=48;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-33)*160+80)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=81;i<=88;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-81)*320+160)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=105;i<=108;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-105)*640+320)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=117;i<=118;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:980px;top:"+String((i-117)*1280+640)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=124;i<=124;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:1220px;top:"+String((i-124)*80+1280)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				//repasague
				for (var i=49;i<=64;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:20px;top:"+String((i-49)*80+2660)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=65;i<=80;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:260px;top:"+String((i-65)*80+2660)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=89;i<=96;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:500px;top:"+String((i-89)*160+2700)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=97;i<=104;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:740px;top:"+String((i-97)*160+2700)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=109;i<=112;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:980px;top:"+String((i-109)*320+2780)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=113;i<=116;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:1220px;top:"+String((i-113)*320+2780)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=119;i<=120;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:1460px;top:"+String((i-119)*640+2950)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				for (var i=121;i<=122;i++) {
					var match=this.collection.where({"number":i})[0];
					var matchView=new MatchView({
						"model":match,
						"attributes":{
							"style":"position:absolute;left:1700px;top:"+String((i-121)*640+2950)+"px;"
						}
					});
					$("#tree-div").append(matchView.render().el);
				}
				if (!displaySettings.get("category").get("treeCategoryOptions").double3rdPlace) {
					for (var i=123;i<=123;i++) {
						var match=this.collection.where({"number":i})[0];
						var matchView=new MatchView({
							"model":match,
							"attributes":{
								"style":"position:absolute;left:1940px;top:"+String((i-123)*80+3260)+"px;"
							}
						});
						$("#tree-div").append(matchView.render().el);
					}
				}
			}
			
			return this;
		}
	});
	
	/*--------- Table ---------*/
	var TableModel=Backbone.Model.extend({
		"url":function() { return contextPath+"/competition/data/table"; },
		"defaults": {
			"rows":null
		}
	});
	
	var TableView=Backbone.View.extend({
		"template":templates.getCompetitionTableTemplate(),
		"initialize":function() {
			this.model.on("change",function() {
				this.render();
			},this);
		},
		"render":function() {
			var tableData=this.model.toJSON();
			tableData.matchesGuide3=displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE3";
			tableData.matchesGuide4=displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE4";
			tableData.matchesGuide5=displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE5";
			
			$(this.el).html(Mustache.render(this.template,tableData));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			return this;
		}
	});
	
	/*--------- Table/tree ---------*/
	var TableOrTreeView=Backbone.View.extend({
		"initialize":function() {
			
		},
		"render":function() {
			$(this.el).html("");
			
			displaySettings.get("category").fetch({
				"async":false
			});
			
			if (displaySettings.get("category").get("type")=="FIGHTING" || displaySettings.get("category").get("type")=="DUO" || displaySettings.get("category").get("type")=="NEWAZA") {
				if ((displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE2")
						|| (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE3")
						|| (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE4")
						|| (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE5")) {
					
					var tableModel=new TableModel();
					tableModel.fetch({
						"data":{
							"categoryId":displaySettings.get("category").get("id")
						},
						"async":false
					});
					
					if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE2") {
						tableModel.set("num",[1,2]);
					}
					else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE3") {
						tableModel.set("num",[1,2,3]);
					}
					else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE4") {
						tableModel.set("num",[1,2,3,4]);
					}
					else if (displaySettings.get("category").get("treeCategoryOptions").treeType=="TABLE5") {
						tableModel.set("num",[1,2,3,4,5]);
					}
					
					var tableView=new TableView({
						"el":$(this.el),
						"model":tableModel
					});
					tableView.render();
				}
				else {
					var matchCollection=new MatchCollection();
					new TreeView({
						"el":$(this.el),
						"collection":matchCollection
					});
					matchCollection.fetch({
						"data": {
							"categoryId":displaySettings.get("category").get("id")
						},
						"reset":true
					});
				}
			}
			else { //CUSTOM
				$(this.el).text(displaySettings.get("category").get("type"));
			}
			
			return this;
		}
	});
	
	/*----- Draw ---------*/
	var DrawAvailableView=Backbone.View.extend({
		"competitorTemplate":"<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-plus\"></i></button> {{name}} / {{clubName}}</div>",
		"initialize":function() {
			this.collection.on("draw-changed",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html("");
			
			var competitors=this.collection;
			
			competitors.each(function(item, index) {
				if (item.get("draw")==null) {
					$(this.el).append(Mustache.render(this.competitorTemplate,item.toJSON()));
				}
			},this);
			
			$("button", this.el).on("click",function() {
				var competitorId=Number($(this).attr("competitorId"));
				var item=competitors.where({"id":competitorId});
				if (item.length>0) {
					var next=null;
					for (var i=1;i<=64;i++) {
						if (competitors.where({"draw":i}).length==0) {
							next=i;
							break;
						}
					}
					item[0].set("draw",next);
				}
				competitors.trigger("draw-changed");
			});
			
			return this;
		}
	});
	
	var DrawDrawedView=Backbone.View.extend({
		"competitorTemplate":"<div><button class=\"btn btn-default btn-sm\" competitorId=\"{{id}}\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}. {{name}} / {{clubName}}</div>",
		"competitorEmptyTemplate":"<div><button class=\"btn btn-default btn-sm\" disabled=\"true\"><i class=\"glyphicon glyphicon-minus\"></i></button> {{draw}}.</div>",
		"initialize":function() {
			this.collection.on("draw-changed",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html("");
			
			var competitors=this.collection;
			
			var draw=[];
			for (var i=0;i<64;i++) {
				draw[i]=null;
			}
			
			this.collection.each(function(item, index) {
				var num=item.get("draw");
				if (num!=null) {
					draw[num-1]=item;
				}
			},this);
			
			for (var i=0;i<64;i++) {
				if (draw[i]!=null) {
					$(this.el).append(Mustache.render(this.competitorTemplate,draw[i].toJSON()));
				}
				else {
					$(this.el).append(Mustache.render(this.competitorEmptyTemplate,{
						"draw":(i+1)
					}));
				}
			}
			
			$("button", this.el).on("click",function() {
				var competitorId=Number($(this).attr("competitorId"));
				var item=competitors.where({"id":competitorId});
				if (item.length>0) {
					item[0].set("draw",null);
				}
				competitors.trigger("draw-changed");
			});
			
			return this;
		}
	});
	
	var DrawView=Backbone.View.extend({
		"template":templates.getCompetitionDrawTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(this.template);
			
			displaySettings.get("category").fetch({
				"async":false
			});
			
			$("#categoryTreeType").val(displaySettings.get("category").get("treeCategoryOptions").treeType);
			$("#categoryRepasageType").val(displaySettings.get("category").get("treeCategoryOptions").repassageType);
			if (displaySettings.get("category").get("treeCategoryOptions").double3rdPlace) {
				$("#categoryDouble3rdPlace").attr("checked","true");
			}
			$("#categoryRepassageFromRound").val(displaySettings.get("category").get("treeCategoryOptions").repassageFromRound);
			
			new DrawAvailableView({
				"el":$("#available"),
				"collection":this.collection
			});
			new DrawDrawedView({
				"el":$("#draw"),
				"collection":this.collection
			});
			
			var competitors=this.collection;
			
			this.collection.on("draw-changed",function() {
				var max=1;
				for (var i=1;i<=64;i++) {
					if (competitors.where({"draw":i}).length!=0) {
						max=i;
					}
				}
				
				$("#categoryTreeType option").removeAttr("disabled");
				
				if (max>2) {
					if ($("#categoryTreeType").val()=="TABLE2") {
						$("#categoryTreeType").val("TABLE3");
					}
					$("#categoryTreeType option[value='TABLE2']").attr("disabled","true");
				}
				if (max>3) {
					if ($("#categoryTreeType").val()=="TABLE3") {
						$("#categoryTreeType").val("TABLE4");
					}
					$("#categoryTreeType option[value='TABLE3']").attr("disabled","true");
				}
				if (max>4) {
					if ($("#categoryTreeType").val()=="TABLE4") {
						$("#categoryTreeType").val("TABLE5");
					}
					if ($("#categoryTreeType").val()=="TREE4") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE4']").attr("disabled","true");
					$("#categoryTreeType option[value='TREE4']").attr("disabled","true");
				}
				if (max>5) {
					if ($("#categoryTreeType").val()=="TABLE5") {
						$("#categoryTreeType").val("TREE8");
					}
					$("#categoryTreeType option[value='TABLE5']").attr("disabled","true");
				}
				if (max>8) {
					if ($("#categoryTreeType").val()=="TREE8") {
						$("#categoryTreeType").val("TREE16");
					}
					$("#categoryTreeType option[value='TREE8']").attr("disabled","true");
				}
				if (max>16) {
					if ($("#categoryTreeType").val()=="TREE16") {
						$("#categoryTreeType").val("TREE32");
					}
					$("#categoryTreeType option[value='TREE16']").attr("disabled","true");
				}
				if (max>32) {
					$("#categoryTreeType option[value='TREE32']").attr("disabled","true");
				}
			},this);
			
			this.collection.trigger("draw-changed");
			
			$(".btn-danger", this.el).on("click",function() {
				competitors.fetch({
					"data": {
						"categoryId":displaySettings.get("category").get("id")
					},
					"reset":true
				});
			});
			
			$(".btn-primary", this.el).on("click",function() {
				var data={
					"categoryId":displaySettings.get("category").get("id"),
					"treeCategoryOptions":null,
					"draw":[]
				};
				
				data.treeCategoryOptions={
					"treeType":$("#categoryTreeType").val(),
					"repassageType":$("#categoryRepasageType").val(),
					"double3rdPlace":$("#categoryDouble3rdPlace").is(":checked"),
					"repassageFromRound":Number($("#categoryRepassageFromRound").val())
				};
				
				competitors.each(function(item, index) {
					data.draw.push({
						"competitorId":item.get("id"),
						"drawNumber":item.get("draw")
					});
				});
				
				$.ajax({
					url:contextPath+"/competition/data/save-draw",
					type: 'POST',
					contentType: "application/json; charset=utf-8",
					data:JSON.stringify(data),
					success: function(responseData){
						if (responseData.success) {
							showSuccessMessage(getSpringMessage("competition.text.drawSaved"));
						}
						else {
							showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
						}
					},
					error: function() {
						showErrorMessage(getSpringMessage("competition.text.drawSavedError"));
					}
				});
			});
			
			$("button[link='clearButton']", this.el).on("click",function() {
				competitors.each(function(item, index) {
					item.set("draw",null);
				});
				competitors.trigger("draw-changed");
			});
			
			function executeDraw() {
				var sameClubCheck=$("#sameClubCheck").is(":checked");
				
				var draw=new CompetitorCollection();
				
				competitors.each(function(item, index) {
					if (item.get("draw")==null) {
						draw.add(item);
					}
				});
				
				if (sameClubCheck) {
					var newDraw=[];
					var n=0;
					while (draw.length>0) {
						var clubId=draw.at(Math.floor(Math.random()*draw.length)).get("clubId");
						var competitorsFromClub=new CompetitorCollection();
						competitorsFromClub.reset(draw.where({"clubId":clubId}));
						while (competitorsFromClub.length>0) {
							var c=competitorsFromClub.at(Math.floor(Math.random()*competitorsFromClub.length));
							competitorsFromClub.remove(c);
							draw.remove(c);
							newDraw[n++]=c;
						}
					}
					draw=newDraw;
				}
				else {
					var newDraw=[];
					var n=0;
					while (draw.length>0) {
						var c=draw.at(Math.floor(Math.random()*draw.length));
						draw.remove(c);
						newDraw[n++]=c;
					}
					draw=newDraw;
				}
				
				for (var j=0;j<draw.length;j++) {
					var next=null;
					for (var i=1;i<=64;i++) {
						if (competitors.where({"draw":i}).length==0) {
							next=i;
							break;
						}
					}
					draw[j].set("draw",next);
				}
				
				competitors.trigger("draw-changed");
			}
			
			$("button[link='executeDraw']", this.el).on("click",function() {
				executeDraw();
			});
			
			$("button[link='clearAndExecuteDraw']", this.el).on("click",function() {
				competitors.each(function(item, index) {
					item.set("draw",null);
				});
				executeDraw();
			});
			
			return this;
		}
	});
	
	/*----- Display settings changed ---------*/
	displaySettings.on("change:category change:type",function() {
		$("#competition-main").html("");
		
		if (this.get("category")==null) {
			return;
		}
		
		if (this.get("category").get("type")=="FIGHTING" || this.get("category").get("type")=="DUO" || this.get("category").get("type")=="NEWAZA") {
			if (this.get("type")=="draw") {
				var competitorCollection=new CompetitorCollection();
				new DrawView({
					"el":$("#competition-main"),
					"collection":competitorCollection
				});
				competitorCollection.fetch({
					"data": {
						"categoryId":this.get("category").get("id")
					},
					"reset":true
				});
			}
			else if (this.get("type")=="tree") {
				var tableOrTreeView=new TableOrTreeView({
					"el":$("#competition-main")
				});
				tableOrTreeView.render();
			}
			else if (this.get("type")=="matches") {
				var matchCollection=new MatchCollection();
				new MatchesView({
					"el":$("#competition-main"),
					"collection":matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId":this.get("category").get("id")
					},
					"reset":true
				});
			}
			else if (this.get("type")=="placings") {
				var placingCollection=new PlacingCollection();
				new PlacingView({
					"el":$("#competition-main"),
					"collection":placingCollection
				});
				placingCollection.fetch({
					"data": {
						"categoryId":this.get("category").get("id")
					},
					"reset":true
				});
			}
		}
		else if (this.get("category").get("type")=="CUSTOM") {
			if (this.get("type")=="matches") {
				var matchCollection=new MatchCollection();
				new CustomMatchesView({
					"el":$("#competition-main"),
					"collection":matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId":this.get("category").get("id")
					},
					"reset":true
				});
			}
		}
	},displaySettings);
	
	displaySettings.on("change:tatami change:tatami-display-type",function() {
		$("#tatami-fights").html("");
		
		if (this.get("tatami-display-type")=="nextFights") {
			var tatamiFightCollection=new TatamiFightCollection();
			
			new TatamiFightsView({
				"el":$("#tatami-fights"),
				"collection":tatamiFightCollection
			});
			
			if (this.get("tatami")!=null) {
				tatamiFightCollection.fetch({
					"data": {
						"tatamiId":this.get("tatami").get("id")
					},
					"reset":true
				});
			}
		}
		else if (this.get("tatami-display-type")=="history") {
			var tatamiHistoryEventCollection=new TatamiHistoryEventCollection();
			
			new TatamiHistoryEventsView({
				"el":$("#tatami-fights"),
				"collection":tatamiHistoryEventCollection
			});
			
			if (this.get("tatami")!=null) {
				tatamiHistoryEventCollection.fetch({
					"data": {
						"tatamiId":this.get("tatami").get("id")
					},
					"reset":true
				});
			}
		}
	},displaySettings);
	
	/*----- Category selector ---------*/
	var CategoryModel=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"name":"",
			"type":"",
			"treeType":"",
			"show":true
		}
	});
	
	var CategoryCollection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/competition/data/category"; },
		"model":CategoryModel
	});
	
	var CategorySelectView=Backbone.View.extend({
		"optionTemplate":"<option value=\"{{id}}\">{{name}}</option>",
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			var obj=this;
			this.collection.each(function(item, index) {
				item.on("change:show",function() {
					obj.reloadCategories();
				});
			});
			
			$(this).html("");
			
			var categories=this.collection;
			
			$(this.el).change(function() {
				var categoryId=Number($(this).val());
				
				var category=categories.where({"id":categoryId});
				if (category.length>0) {
					displaySettings.set("category",category[0]);
				}
			});
			
			this.collection.each(function(item, index) {
				if (item.get("show")) {
					$(this.el).append(Mustache.render(this.optionTemplate,item.toJSON()));
				}
			},this);
			
			$(this.el).chosen({
				"search_contains":true,
				"width":"200px"
			});
			
			var enabledCategories=this.collection.where({"show":true});
			
			if (enabledCategories.length>0) {
				displaySettings.set("category",enabledCategories[0]);
			}
			
			return this;
		},
		"reloadCategories":function() {
			var selectedCategoryId=$(this.el).val();
			
			$(this.el).html("");
			
			this.collection.each(function(item, index) {
				if (item.get("show")) {
					$(this.el).append(Mustache.render(this.optionTemplate,item.toJSON()));
				}
			},this);
			$("option[value='"+selectedCategoryId+"']",this.el).prop("selected", true);
			
			$(this.el).trigger("liszt:updated");
			$(this.el).trigger('chosen:updated');
			
			var enabledCategories=this.collection.where({"show":true});
			
			if (enabledCategories.length>0) {
				if (selectedCategoryId) {
					var category=this.collection.where({"id":Number(selectedCategoryId),"show":true});
					if (category.length>0) {
						displaySettings.set("category",category[0]);
					}
					else {
						displaySettings.set("category",enabledCategories[0]);
					}
				}
				else {
					displaySettings.set("category",enabledCategories[0]);
				}
			}
		}
	});
	
	var CategoryEnableView=Backbone.View.extend({
		"optionTemplate":"<li><input style=\"margin-right:5px;margin-top:-3px;\" type=\"checkbox\"{{#show}} checked=\"true\"{{/show}} categoryId=\"{{id}}\" /><label>{{name}}</label></li>",
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this).html("");
			
			var categories=this.collection;
			
			this.collection.each(function(item, index) {
				$(this.el).append(Mustache.render(this.optionTemplate,item.toJSON()));
			},this);
			
			$("input[type='checkbox']",this.el).change(function() {
				var categoryId=Number($(this).attr("categoryId"));
				var showCategory=$(this).is(":checked");
				
				var category=categories.where({"id":categoryId});
				if (category.length>0) {
					category[0].set("show",showCategory);
				}
				
				$.ajax({
					"url":contextPath+"/competition/data/show-category/"+String(categoryId)+"/"+String(showCategory),
					"type":"GET"
				});
			});
			
			$("input[type='checkbox']",this.el).on("click",function(e) {
				e.stopPropagation();
			});
			
			$("label",this.el).on("click",function(e) {
				$(this).parent().find("input[type='checkbox']").click();
				e.stopPropagation();
			});
			
			return this;
		}
	});
	
	/*----- Competition ---------*/
	window.jtekma.competition={};
	
	window.jtekma.competition.model=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"name":"",
			"date":null,
			"status":"",
			"canManage":false
		},
		"url":function() { return contextPath+"/competition/data/current-competition"; },
		"initialize":function() {
			
		}
	});
	
	window.jtekma.competition.view=Backbone.View.extend({
		"template":templates.getCompetitionTemplate(),
		"initialize":function() {
			this.model.on("change",function() {
				this.render();
			},this);
		},
		"render":function() {
			$(this.el).html(this.template);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$("#displayButtons label",this.el).on("click",function() {
				displaySettings.set("type",$(this).attr("link"));
			});
			
			$("#displayButtons label:first").click();
			
			var categoryCollection=new CategoryCollection();
			new CategorySelectView({
				"el":$("#category-select"),
				"collection":categoryCollection
			});
			new CategoryEnableView({
				"el":$("#category-enable-list"),
				"collection":categoryCollection
			});
			categoryCollection.fetch({"reset":true});
			
			var tatamiCollection=new TatamiCollection();
			new TatamiSelectView({
				"el":$("#tatami-select"),
				"collection":tatamiCollection
			});
			tatamiCollection.fetch({"reset":true});
			
			$(".addEventButton",this.el).on("click",function() {
				var eventModel=new EventModel();
				var eventEditView=new EventEditView({
					"model":eventModel
				});
				eventEditView.trigger("show");
			});
			
			$("#tatamiDisplayButtons label",this.el).on("click",function() {
				displaySettings.set("tatami-display-type", $(this).attr("link"));
			});
			
			$("#tatamiDisplayButtons label:first").click();
			
			$(".refreshButton",this.el).on("click",function() {
				reloadData();
			});
			
			var autoReload=false;
			
			$(".autoRefreshButton",this.el).on("click",function() {
				autoReload=$(this).attr("class").indexOf("active")<0;
				if (autoReload) {
					reloadData();
				}
			});
			
			setInterval(function(){
				if (autoReload) {
					reloadData();
				}
			}, 30000);
			
			return this;
		}
	});
	
})();

$(document).ready(function() {
	var competitionModel=new window.jtekma.competition.model();
	
	new window.jtekma.competition.view({
		"el":$("#competition-div"),
		"model":competitionModel
	});
	
	competitionModel.fetch();
});