/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.highcharts;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import si.nevensrok.common.web.highcharts.ChartData;
import si.nevensrok.common.web.highcharts.HighchartsData;
import si.nevensrok.common.web.highcharts.IndexFormatter;
import si.nevensrok.common.web.highcharts.PieData;

public class HighchartsUtil {
    public static <T, K> HighchartsData generateHighchartsData(Map<String, Map<T, K>> data, IndexFormatter<T> indexFormatter) throws Exception {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        LinkedList chartDatas = new LinkedList();
        for (Map.Entry<String, Map<T, K>> reportEntry : data.entrySet()) {
            ChartData chartData = new ChartData(reportEntry.getKey(), new LinkedList());
            chartDatas.add(chartData);
            for (Map.Entry<T, K> dataEntry : reportEntry.getValue().entrySet()) {
                String indexText = indexFormatter.formatIndex(dataEntry.getKey());
                categories.add(indexText);
                chartData.getData().add(dataEntry.getValue());
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        String dataJson = mapper.writeValueAsString(chartDatas);
        String categoriesJson = mapper.writeValueAsString(categories);
        return new HighchartsData(dataJson, categoriesJson);
    }

    public static <T, K> HighchartsData generateHighchartsPieData(Map<T, K> data, IndexFormatter<T> indexFormatter) throws Exception {
        LinkedList chartDatas = new LinkedList();
        ChartData chartData = new ChartData("", new LinkedList());
        chartDatas.add(chartData);
        for (Map.Entry<T, K> dataEntry : data.entrySet()) {
            String indexText = indexFormatter.formatIndex(dataEntry.getKey());
            chartData.getData().add(new PieData<K>(indexText, dataEntry.getValue()));
        }
        ObjectMapper mapper = new ObjectMapper();
        String dataJson = mapper.writeValueAsString(chartDatas);
        String categoriesJson = "[]";
        return new HighchartsData(dataJson, categoriesJson);
    }
}

