/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.Calendar;
import java.util.Set;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.TablaService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class TablaServiceImpl
implements TablaService {
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private TatamiFightsManager tatamiFightsManager;
    private CategoryManager categoryManager;
    private CompetitionManager competitionManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private TatamiHistoryManager tatamiHistoryManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        return tatami != null;
    }

    public NextMatchData getNextMatch(Credentials credentials) throws ServiceException {
        NewazaCategory newazaCategory;
        AgeCategoryOption ageCategoryOption;
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Match match = this.tatamiFightsManager.getNextMatchForTatami(tatami);
        if (match == null) {
            return null;
        }
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setTatami(tatami);
        tatamiHistory.setEventDate(Calendar.getInstance().getTime());
        tatamiHistory.setEventType(TatamiHistory.EventType.PULLMATCH);
        tatamiHistory.setMatch(match);
        this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
        match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
        match.setStartedAt(Calendar.getInstance().getTime());
        this.matchManager.setMatchStartedAt(match);
        Category category = this.categoryManager.getCategoryForMatch(match);
        match.setCategory(category);
        Competition competition = this.competitionManager.getCompetitionForCategory(category);
        NextMatchData nextMatchData = new NextMatchData();
        nextMatchData.setMatch(match);
        nextMatchData.setRules(competition.getRules());
        nextMatchData.setMatchTime(match.getFightTimeLeft());
        nextMatchData.setHosekomiTime(match.getHosekomiTime());
        nextMatchData.setInjuryTime1(match.getInjuryTime1());
        nextMatchData.setInjuryTime2(match.getInjuryTime2());
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            AgeCategoryOption ageCategoryOption2 = this.ageCategoryOptionManager.getForCategory(fightingCategory);
            if (ageCategoryOption2 != null) {
                if (ageCategoryOption2.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                    nextMatchData.setMatchTime(ageCategoryOption2.getFightTime());
                }
                if (ageCategoryOption2.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                    nextMatchData.setHosekomiTime(ageCategoryOption2.getHosekomiTime());
                }
            }
        } else if (category instanceof NewazaCategory && (ageCategoryOption = this.ageCategoryOptionManager.getForCategory(newazaCategory = (NewazaCategory)category)) != null) {
            if (ageCategoryOption.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                nextMatchData.setMatchTime(ageCategoryOption.getFightTime());
            }
            if (ageCategoryOption.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                nextMatchData.setHosekomiTime(ageCategoryOption.getHosekomiTime());
            }
        }
        if (nextMatchData.getMatchTime() == null) {
            nextMatchData.setMatchTime(Integer.valueOf(180));
        }
        if (nextMatchData.getHosekomiTime() == null) {
            nextMatchData.setHosekomiTime(Integer.valueOf(15));
        }
        Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
        nextMatchData.setMatchPoints(matchPoints);
        return nextMatchData;
    }

    public void setPartialData(Credentials credentials, Match match, Set<MatchPoint> matchPoints, Integer fightTimeLeft, Integer injuryTime1, Integer injuryTime2) {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
        if (matchTatami == null) {
            throw new ServiceException("Match is not on tatami");
        }
        if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
            throw new ServiceException("Match is not on tatami");
        }
        match = this.matchManager.getById(match.getMatchId());
        match.setFightTimeLeft(fightTimeLeft);
        match.setInjuryTime1(injuryTime1);
        match.setInjuryTime2(injuryTime2);
        if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
            this.matchManager.setMatchPointsForMatch(match, matchPoints);
            this.matchManager.setFightTimeLeft(match);
            this.matchManager.setInjuryTime(match);
        }
    }

    public void finishMatch(Credentials credentials, Match match, Set<MatchPoint> matchPoints, Set<PointDetail> pointDetails, Integer fightTimeLeft, Integer injuryTime1, Integer injuryTime2) throws ServiceException {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
        if (matchTatami == null) {
            throw new ServiceException("Match is not on tatami");
        }
        if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
            throw new ServiceException("Match is not on tatami");
        }
        Long matchId = match.getMatchId();
        if ((match = this.matchManager.getById(matchId)) == null) {
            throw new ServiceException("Match with id [" + matchId + "] not found");
        }
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setTatami(tatami);
        tatamiHistory.setEventDate(Calendar.getInstance().getTime());
        tatamiHistory.setEventType(TatamiHistory.EventType.PUSHMATCH);
        tatamiHistory.setMatch(match);
        this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
        match.setFightTimeLeft(fightTimeLeft);
        match.setInjuryTime1(injuryTime1);
        match.setInjuryTime2(injuryTime2);
        if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
            this.matchManager.setMatchPointsForMatch(match, matchPoints);
            this.matchManager.setMatchPointDetailsForMatch(match, pointDetails);
            this.matchManager.setFightTimeLeft(match);
            this.matchManager.setInjuryTime(match);
            this.matchManager.setMatchStatus(match, Match.Status.FINISHED);
            match.setFinishedAt(Calendar.getInstance().getTime());
            this.matchManager.setMatchFinishedAt(match);
        }
    }
}

