/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.common;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import si.nevensrok.common.web.security.impl.UserAuthentication;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.security.LoginUserInfo;

public class UserData
implements Serializable {
    private static final long serialVersionUID = 2028222097568621246L;
    private static final Logger log = LoggerFactory.getLogger(UserData.class);
    private Competition competition;
    private String recoverPasswordCaptcha;

    public UserData() {
        this.invalidate();
    }

    public User getLoginedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            if (log.isDebugEnabled()) {
                log.debug("Authentication is null");
            }
            return null;
        }
        if (authentication instanceof UserAuthentication) {
            UserAuthentication userAuthentication = (UserAuthentication)authentication;
            LoginUserInfo loginUserInfo = (LoginUserInfo)userAuthentication.getUserData();
            return loginUserInfo.getUser();
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            log.debug("Authentication is anonymous");
            return null;
        }
        log.error("Authentication does not implement UserAuthentication but is of class {}", (Object)authentication.getClass().getName());
        return null;
    }

    public Competition getCompetition() {
        return this.competition;
    }

    public void setCompetition(Competition competition) {
        this.competition = competition;
    }

    public String getRecoverPasswordCaptcha() {
        return this.recoverPasswordCaptcha;
    }

    public void setRecoverPasswordCaptcha(String recoverPasswordCaptcha) {
        this.recoverPasswordCaptcha = recoverPasswordCaptcha;
    }

    public void invalidate() {
        this.competition = null;
        this.recoverPasswordCaptcha = null;
    }
}

