/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servlet.util.matcher;

import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.UrlPathHelper;

public class MvcRequestMatcher
implements RequestMatcher,
RequestVariablesExtractor,
InitializingBean,
ServletContextAware {
    private static final boolean isServlet30 = ClassUtils.isPresent((String)"javax.servlet.ServletRegistration", (ClassLoader)MvcRequestMatcher.class.getClassLoader());
    private final DefaultMatcher defaultMatcher = new DefaultMatcher();
    private final HandlerMappingIntrospector introspector;
    private final String pattern;
    private HttpMethod method;
    private String servletPath;
    private ServletContext servletContext;

    public MvcRequestMatcher(HandlerMappingIntrospector introspector, String pattern) {
        this.introspector = introspector;
        this.pattern = pattern;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.method != null && !this.method.name().equals(request.getMethod())) {
            return false;
        }
        if (this.servletPath != null && !this.servletPath.equals(request.getServletPath())) {
            return false;
        }
        MatchableHandlerMapping mapping = this.getMapping(request);
        if (mapping == null) {
            return this.defaultMatcher.matches(request);
        }
        RequestMatchResult matchResult = mapping.match(request, this.pattern);
        return matchResult != null;
    }

    private MatchableHandlerMapping getMapping(HttpServletRequest request) {
        try {
            return this.introspector.getMatchableHandlerMapping(request);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Map<String, String> extractUriTemplateVariables(HttpServletRequest request) {
        MatchableHandlerMapping mapping = this.getMapping(request);
        if (mapping == null) {
            return this.defaultMatcher.extractUriTemplateVariables(request);
        }
        RequestMatchResult result = mapping.match(request, this.pattern);
        return result == null ? Collections.emptyMap() : result.extractUriTemplateVariables();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.servletContext == null || !isServlet30) {
            return;
        }
        if (this.getServletPath() != null) {
            return;
        }
        for (ServletRegistration registration : this.servletContext.getServletRegistrations().values()) {
            for (String mapping : registration.getMappings()) {
                if (!mapping.startsWith("/") || mapping.length() <= 1) continue;
                throw new IllegalStateException("servletPath must not be null for mvcPattern \"" + this.getMvcPattern() + "\" when providing a servlet mapping of " + mapping + " for servlet " + registration.getClassName());
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    protected final String getServletPath() {
        return this.servletPath;
    }

    protected final String getMvcPattern() {
        return this.pattern;
    }

    private class DefaultMatcher
    implements RequestMatcher,
    RequestVariablesExtractor {
        private final UrlPathHelper pathHelper = new UrlPathHelper();
        private final PathMatcher pathMatcher = new AntPathMatcher();

        private DefaultMatcher() {
        }

        @Override
        public boolean matches(HttpServletRequest request) {
            String lookupPath = this.pathHelper.getLookupPathForRequest(request);
            return this.matches(lookupPath);
        }

        private boolean matches(String lookupPath) {
            return this.pathMatcher.match(MvcRequestMatcher.this.pattern, lookupPath);
        }

        @Override
        public Map<String, String> extractUriTemplateVariables(HttpServletRequest request) {
            String lookupPath = this.pathHelper.getLookupPathForRequest(request);
            if (this.matches(lookupPath)) {
                return this.pathMatcher.extractUriTemplateVariables(MvcRequestMatcher.this.pattern, lookupPath);
            }
            return Collections.emptyMap();
        }
    }
}

