/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.generator;

import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomStringGenerator
implements IdentifierGenerator,
Configurable {
    private Logger log = LoggerFactory.getLogger(RandomStringGenerator.class);
    private int length = 20;
    private char[] characters = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private Random random = new Random();

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        if (params.containsKey("length")) {
            try {
                this.length = Integer.parseInt(params.getProperty("length"));
            }
            catch (Exception e) {
                this.log.error("Error configuring length parameter", (Throwable)e);
            }
        }
    }

    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object object) throws HibernateException {
        StringBuilder text = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            text.append(this.characters[this.random.nextInt(this.characters.length)]);
        }
        return text.toString();
    }
}

