/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryGroupDTO;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryInGroupDTO;

public class CategoryGroupDAO
extends ExtendedDao<Long, CategoryGroupDTO, CategoryGroup> {
    public CategoryGroupDAO() {
        super(CategoryGroupDTO.class, CategoryGroup.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.compareToIgnoreCase("id") == 0) {
            return "c.categoryGroupId";
        }
        if (fieldName.compareToIgnoreCase("categoryGroupId") == 0) {
            return "c.categoryGroupId";
        }
        if (fieldName.compareToIgnoreCase("name") == 0) {
            return "c.name";
        }
        if (fieldName.compareToIgnoreCase("competition") == 0) {
            return "c.competition.competitionId";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public CategoryGroup getCategoryGroupByName(Competition competition, String name) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select categoryGroup from CategoryGroupDTO as categoryGroup where categoryGroup.competition.competitionId=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(" and upper(categoryGroup.name)=");
        sql.append(params.addParam(name.toUpperCase()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CategoryGroupDTO categoryGroupDTO = (CategoryGroupDTO)((Object)CategoryGroupDAO.getSingleResult((Query)query));
        CategoryGroup categoryGroup = null;
        if (categoryGroupDTO != null) {
            categoryGroup = (CategoryGroup)this.adapterPool.create(CategoryGroup.class, (Object)categoryGroupDTO);
        }
        this.flush();
        return categoryGroup;
    }

    public void setCategoriesForGroup(CategoryGroup categoryGroup, List<Category> categories) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from CategoryInGroupDTO where categoryInGroupKey.categoryGroup.categoryGroupId=");
        sql.append(params.addParam(categoryGroup.getCategoryGroupId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        CategoryGroupDTO categoryGroupDTO = new CategoryGroupDTO();
        categoryGroupDTO.setCategoryGroupId(categoryGroup.getCategoryGroupId());
        for (Category category : categories) {
            CategoryDTO categoryDTO = new CategoryDTO();
            categoryDTO.setCategoryId(category.getCategoryId());
            CategoryInGroupDTO categoryInGroupDTO = new CategoryInGroupDTO(categoryGroupDTO, categoryDTO);
            this.createInstance(categoryInGroupDTO);
        }
        this.flush();
    }

    public List<Category> getCategoriesForGroup(CategoryGroup categoryGroup) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select categoryInGroup.categoryInGroupKey.category from CategoryInGroupDTO as categoryInGroup where categoryInGroup.categoryInGroupKey.categoryGroup.categoryGroupId=");
        sql.append(params.addParam(categoryGroup.getCategoryGroupId()));
        sql.append(" and categoryInGroup.categoryInGroupKey.category.status=");
        sql.append(params.addParam((Object)Category.Status.ACTIVE));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Category> categories = new LinkedList<Category>();
        for (CategoryDTO categoryDTO : list) {
            Category category = (Category)this.adapterPool.getAdapter(CategoryDTO.class, Category.class).create((Object)categoryDTO);
            categories.add(category);
        }
        this.flush();
        return categories;
    }

    public void setCategoryGroupsForCategory(Category category, List<CategoryGroup> categoryGroups) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from CategoryInGroupDTO where categoryInGroupKey.category.categoryId=");
        sql.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        for (CategoryGroup categoryGroup : categoryGroups) {
            CategoryGroupDTO categoryGroupDTO = new CategoryGroupDTO();
            categoryGroupDTO.setCategoryGroupId(categoryGroup.getCategoryGroupId());
            CategoryInGroupDTO categoryInGroupDTO = new CategoryInGroupDTO(categoryGroupDTO, categoryDTO);
            this.createInstance(categoryInGroupDTO);
        }
        this.flush();
    }

    public List<CategoryGroup> getCategoryGroupsForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select categoryInGroup.categoryInGroupKey.categoryGroup from CategoryInGroupDTO as categoryInGroup where categoryInGroup.categoryInGroupKey.category.categoryId=");
        sql.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<CategoryGroup> categoryGroups = new LinkedList<CategoryGroup>();
        for (CategoryGroupDTO categoryGroupDTO : list) {
            CategoryGroup categoryGroup = (CategoryGroup)this.adapterPool.getAdapter(CategoryGroupDTO.class, CategoryGroup.class).create((Object)categoryGroupDTO);
            categoryGroups.add(categoryGroup);
        }
        this.flush();
        return categoryGroups;
    }

    public boolean isInCategoryGroup(CategoryGroup categoryGroup, Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from CategoryInGroupDTO as categoryInGroup where categoryInGroup.categoryInGroupKey.category.categoryId=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and categoryInGroup.categoryInGroupKey.categoryGroup.categoryGroupId=");
        sql.append(params.addParam(categoryGroup.getCategoryGroupId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        Long count = (Long)CategoryGroupDAO.getSingleResult((Query)query);
        this.flush();
        return count > 0L;
    }
}

