/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.HashMap;
import java.util.Map;

public class PlaceholderUtil {
    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern) {
        return PlaceholderUtil.replacePlaceHolders(text, placeholders, startPattern, "", false);
    }

    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern, String endPattern) {
        return PlaceholderUtil.replacePlaceHolders(text, placeholders, startPattern, endPattern, false);
    }

    public static String replacePlaceHolders(String text, Map<String, String> placeholders, String startPattern, String endPattern, boolean caseSensitive) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        HashMap<String, String> replacments = new HashMap<String, String>();
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                if (entry.getKey() == null) continue;
                if (caseSensitive) {
                    replacments.put(entry.getKey().trim(), entry.getValue() == null ? "" : entry.getValue().trim());
                    continue;
                }
                replacments.put(entry.getKey().trim().toUpperCase(), entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
        StringBuilder buffer = new StringBuilder(text);
        int startIndex = buffer.indexOf(startPattern);
        while (startIndex >= 0) {
            int endIndex = -1;
            if (endPattern.isEmpty()) {
                endIndex = buffer.indexOf(" ", startIndex + 1);
                if (endIndex < 0) {
                    endIndex = buffer.length();
                }
            } else {
                endIndex = buffer.indexOf(endPattern, startIndex + 1);
            }
            if (endIndex < 0) break;
            String name = buffer.substring(startIndex + startPattern.length(), endIndex);
            String replacment = caseSensitive ? (String)replacments.get(name.trim()) : (String)replacments.get(name.trim().toUpperCase());
            if (replacment == null) {
                replacment = "";
            }
            buffer.replace(startIndex, endIndex + endPattern.length(), replacment);
            startIndex = buffer.indexOf(startPattern, startIndex + 1);
        }
        return buffer.toString();
    }
}

