/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.HashMap;
import java.util.Map;

public class MimeTypeUtil {
    private static final Map<String, String> knownMimeTypes = new HashMap<String, String>();
    private static final String defaultMimeType = "application/octet-stream";

    public static String getMimeTypeByFileName(String fileName) {
        int n = (fileName = fileName.toLowerCase()).lastIndexOf(46);
        if (n < 0) {
            return defaultMimeType;
        }
        String fileSuffix = fileName.substring(n + 1, fileName.length());
        String mimeType = knownMimeTypes.get(fileSuffix);
        if (mimeType != null) {
            return mimeType;
        }
        return defaultMimeType;
    }

    static {
        knownMimeTypes.put("123", "application/vnd.lotus-1-2-3");
        knownMimeTypes.put("3dm", "x-world/x-3dmf");
        knownMimeTypes.put("3dmf", "x-world/x-3dmf");
        knownMimeTypes.put("3dml", "text/vnd.in3d.3dml");
        knownMimeTypes.put("3g2", "video/3gpp2");
        knownMimeTypes.put("3gp", "video/3gpp");
        knownMimeTypes.put("7z", "application/x-7z-compressed");
        knownMimeTypes.put("a", defaultMimeType);
        knownMimeTypes.put("aab", "application/x-authorware-bin");
        knownMimeTypes.put("aac", "audio/x-aac");
        knownMimeTypes.put("aam", "application/x-authorware-map");
        knownMimeTypes.put("aas", "application/x-authorware-seg");
        knownMimeTypes.put("abc", "text/vnd.abc");
        knownMimeTypes.put("abw", "application/x-abiword");
        knownMimeTypes.put("ac", "application/pkix-attr-cert");
        knownMimeTypes.put("acc", "application/vnd.americandynamics.acc");
        knownMimeTypes.put("ace", "application/x-ace-compressed");
        knownMimeTypes.put("acgi", "text/html");
        knownMimeTypes.put("acu", "application/vnd.acucobol");
        knownMimeTypes.put("adp", "audio/adpcm");
        knownMimeTypes.put("aep", "application/vnd.audiograph");
        knownMimeTypes.put("afl", "video/animaflex");
        knownMimeTypes.put("afp", "application/vnd.ibm.modcap");
        knownMimeTypes.put("ahead", "application/vnd.ahead.space");
        knownMimeTypes.put("ai", "application/postscript");
        knownMimeTypes.put("aif", "audio/x-aiff");
        knownMimeTypes.put("aifc", "audio/aiff");
        knownMimeTypes.put("aiff", "audio/aiff");
        knownMimeTypes.put("aim", "application/x-aim");
        knownMimeTypes.put("aip", "text/x-audiosoft-intra");
        knownMimeTypes.put("air", "application/vnd.adobe.air-application-installer-package+zip");
        knownMimeTypes.put("ait", "application/vnd.dvb.ait");
        knownMimeTypes.put("ami", "application/vnd.amiga.ami");
        knownMimeTypes.put("ani", "application/x-navi-animation");
        knownMimeTypes.put("aos", "application/x-nokia-9000-communicator-add-on-software");
        knownMimeTypes.put("apk", "application/vnd.android.package-archive");
        knownMimeTypes.put("application", "application/x-ms-application");
        knownMimeTypes.put("apr", "application/vnd.lotus-approach");
        knownMimeTypes.put("aps", "application/mime");
        knownMimeTypes.put("arc", defaultMimeType);
        knownMimeTypes.put("arj", "application/arj");
        knownMimeTypes.put("art", "image/x-jg");
        knownMimeTypes.put("asf", "video/x-ms-asf");
        knownMimeTypes.put("asm", "text/x-asm");
        knownMimeTypes.put("aso", "application/vnd.accpac.simply.aso");
        knownMimeTypes.put("asp", "text/asp");
        knownMimeTypes.put("asx", "application/x-mplayer2");
        knownMimeTypes.put("atc", "application/vnd.acucorp");
        knownMimeTypes.put("atom", "application/atom+xml");
        knownMimeTypes.put("atomcat", "application/atomcat+xml");
        knownMimeTypes.put("atomsvc", "application/atomsvc+xml");
        knownMimeTypes.put("atx", "application/vnd.antix.game-component");
        knownMimeTypes.put("au", "audio/basic");
        knownMimeTypes.put("avi", "video/avi");
        knownMimeTypes.put("avs", "video/avs-video");
        knownMimeTypes.put("aw", "application/applixware");
        knownMimeTypes.put("azf", "application/vnd.airzip.filesecure.azf");
        knownMimeTypes.put("azs", "application/vnd.airzip.filesecure.azs");
        knownMimeTypes.put("azw", "application/vnd.amazon.ebook");
        knownMimeTypes.put("bcpio", "application/x-bcpio");
        knownMimeTypes.put("bdf", "application/x-font-bdf");
        knownMimeTypes.put("bdm", "application/vnd.syncml.dm+wbxml");
        knownMimeTypes.put("bed", "application/vnd.realvnc.bed");
        knownMimeTypes.put("bh2", "application/vnd.fujitsu.oasysprs");
        knownMimeTypes.put("bin", defaultMimeType);
        knownMimeTypes.put("bm", "image/bmp");
        knownMimeTypes.put("bmi", "application/vnd.bmi");
        knownMimeTypes.put("bmp", "image/bmp");
        knownMimeTypes.put("boo", "application/book");
        knownMimeTypes.put("book", "application/book");
        knownMimeTypes.put("box", "application/vnd.previewsystems.box");
        knownMimeTypes.put("boz", "application/x-bzip2");
        knownMimeTypes.put("bsh", "application/x-bsh");
        knownMimeTypes.put("btif", "image/prs.btif");
        knownMimeTypes.put("bz", "application/x-bzip");
        knownMimeTypes.put("bz2", "application/x-bzip2");
        knownMimeTypes.put("c", "text/x-c");
        knownMimeTypes.put("c++", "text/plain");
        knownMimeTypes.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
        knownMimeTypes.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
        knownMimeTypes.put("c4g", "application/vnd.clonk.c4group");
        knownMimeTypes.put("cab", "application/vnd.ms-cab-compressed");
        knownMimeTypes.put("car", "application/vnd.curl.car");
        knownMimeTypes.put("cat", "application/vnd.ms-pki.seccat");
        knownMimeTypes.put("cc", "text/x-c");
        knownMimeTypes.put("ccad", "application/clariscad");
        knownMimeTypes.put("cco", "application/x-cocoa");
        knownMimeTypes.put("ccxml", "application/ccxml+xml,");
        knownMimeTypes.put("cdbcmsg", "application/vnd.contact.cmsg");
        knownMimeTypes.put("cdf", "application/cdf");
        knownMimeTypes.put("cdkey", "application/vnd.mediastation.cdkey");
        knownMimeTypes.put("cdmia", "application/cdmi-capability");
        knownMimeTypes.put("cdmic", "application/cdmi-container");
        knownMimeTypes.put("cdmid", "application/cdmi-domain");
        knownMimeTypes.put("cdmio", "application/cdmi-object");
        knownMimeTypes.put("cdmiq", "application/cdmi-queue");
        knownMimeTypes.put("cdx", "chemical/x-cdx");
        knownMimeTypes.put("cdxml", "application/vnd.chemdraw+xml");
        knownMimeTypes.put("cdy", "application/vnd.cinderella");
        knownMimeTypes.put("cer", "application/x-x509-ca-cert");
        knownMimeTypes.put("cgm", "image/cgm");
        knownMimeTypes.put("cha", "application/x-chat");
        knownMimeTypes.put("chat", "application/x-chat");
        knownMimeTypes.put("chm", "application/vnd.ms-htmlhelp");
        knownMimeTypes.put("chrt", "application/vnd.kde.kchart");
        knownMimeTypes.put("cif", "chemical/x-cif");
        knownMimeTypes.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
        knownMimeTypes.put("cil", "application/vnd.ms-artgalry");
        knownMimeTypes.put("cla", "application/vnd.claymore");
        knownMimeTypes.put("class", "application/java-byte-code");
        knownMimeTypes.put("clkk", "application/vnd.crick.clicker.keyboard");
        knownMimeTypes.put("clkp", "application/vnd.crick.clicker.palette");
        knownMimeTypes.put("clkt", "application/vnd.crick.clicker.template");
        knownMimeTypes.put("clkw", "application/vnd.crick.clicker.wordbank");
        knownMimeTypes.put("clkx", "application/vnd.crick.clicker");
        knownMimeTypes.put("clp", "application/x-msclip");
        knownMimeTypes.put("cmc", "application/vnd.cosmocaller");
        knownMimeTypes.put("cmdf", "chemical/x-cmdf");
        knownMimeTypes.put("cml", "chemical/x-cml");
        knownMimeTypes.put("cmp", "application/vnd.yellowriver-custom-menu");
        knownMimeTypes.put("cmx", "image/x-cmx");
        knownMimeTypes.put("cod", "application/vnd.rim.cod");
        knownMimeTypes.put("com", defaultMimeType);
        knownMimeTypes.put("conf", "text/plain");
        knownMimeTypes.put("cpio", "application/x-cpio");
        knownMimeTypes.put("cpp", "text/x-c");
        knownMimeTypes.put("cpt", "application/x-cpt");
        knownMimeTypes.put("crd", "application/x-mscardfile");
        knownMimeTypes.put("crl", "application/pkix-crl");
        knownMimeTypes.put("crt", "application/pkix-cert");
        knownMimeTypes.put("cryptonote", "application/vnd.rig.cryptonote");
        knownMimeTypes.put("csh", "application/x-csh");
        knownMimeTypes.put("csml", "chemical/x-csml");
        knownMimeTypes.put("csp", "application/vnd.commonspace");
        knownMimeTypes.put("css", "text/css");
        knownMimeTypes.put("csv", "text/csv");
        knownMimeTypes.put("cu", "application/cu-seeme");
        knownMimeTypes.put("curl", "text/vnd.curl");
        knownMimeTypes.put("cww", "application/prs.cww");
        knownMimeTypes.put("cxx", "text/plain");
        knownMimeTypes.put("dae", "model/vnd.collada+xml");
        knownMimeTypes.put("daf", "application/vnd.mobius.daf");
        knownMimeTypes.put("davmount", "application/davmount+xml");
        knownMimeTypes.put("dcr", "application/x-director");
        knownMimeTypes.put("dcurl", "text/vnd.curl.dcurl");
        knownMimeTypes.put("dd2", "application/vnd.oma.dd2+xml");
        knownMimeTypes.put("ddd", "application/vnd.fujixerox.ddd");
        knownMimeTypes.put("deb", "application/x-debian-package");
        knownMimeTypes.put("deepv", "application/x-deepv");
        knownMimeTypes.put("def", "text/plain");
        knownMimeTypes.put("der", "application/x-x509-ca-cert");
        knownMimeTypes.put("dfac", "application/vnd.dreamfactory");
        knownMimeTypes.put("dif", "video/x-dv");
        knownMimeTypes.put("dir", "application/x-director");
        knownMimeTypes.put("dis", "application/vnd.mobius.dis");
        knownMimeTypes.put("djvu", "image/vnd.djvu");
        knownMimeTypes.put("dl", "video/dl");
        knownMimeTypes.put("dna", "application/vnd.dna");
        knownMimeTypes.put("doc", "application/msword");
        knownMimeTypes.put("docm", "application/vnd.ms-word.document.macroenabled.12");
        knownMimeTypes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        knownMimeTypes.put("dot", "application/msword");
        knownMimeTypes.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
        knownMimeTypes.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        knownMimeTypes.put("dp", "application/vnd.osgi.dp");
        knownMimeTypes.put("dpg", "application/vnd.dpgraph");
        knownMimeTypes.put("dra", "audio/vnd.dra");
        knownMimeTypes.put("drw", "application/drafting");
        knownMimeTypes.put("dsc", "text/prs.lines.tag");
        knownMimeTypes.put("dssc", "application/dssc+der");
        knownMimeTypes.put("dtb", "application/x-dtbook+xml");
        knownMimeTypes.put("dtd", "application/xml-dtd");
        knownMimeTypes.put("dts", "audio/vnd.dts");
        knownMimeTypes.put("dtshd", "audio/vnd.dts.hd");
        knownMimeTypes.put("dump", defaultMimeType);
        knownMimeTypes.put("dv", "video/x-dv");
        knownMimeTypes.put("dvi", "application/x-dvi");
        knownMimeTypes.put("dwf", "model/vnd.dwf");
        knownMimeTypes.put("dwg", "image/vnd.dwg");
        knownMimeTypes.put("dxf", "image/vnd.dxf");
        knownMimeTypes.put("dxp", "application/vnd.spotfire.dxp");
        knownMimeTypes.put("dxr", "application/x-director");
        knownMimeTypes.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
        knownMimeTypes.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
        knownMimeTypes.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
        knownMimeTypes.put("edm", "application/vnd.novadigm.edm");
        knownMimeTypes.put("edx", "application/vnd.novadigm.edx");
        knownMimeTypes.put("efif", "application/vnd.picsel");
        knownMimeTypes.put("ei6", "application/vnd.pg.osasli");
        knownMimeTypes.put("el", "text/x-script.elisp");
        knownMimeTypes.put("elc", "application/x-elc");
        knownMimeTypes.put("eml", "message/rfc822");
        knownMimeTypes.put("emma", "application/emma+xml");
        knownMimeTypes.put("env", "application/x-envoy");
        knownMimeTypes.put("eol", "audio/vnd.digital-winds");
        knownMimeTypes.put("eot", "application/vnd.ms-fontobject");
        knownMimeTypes.put("eps", "application/postscript");
        knownMimeTypes.put("epub", "application/epub+zip");
        knownMimeTypes.put("es", "application/ecmascript");
        knownMimeTypes.put("es3", "application/vnd.eszigno3+xml");
        knownMimeTypes.put("esf", "application/vnd.epson.esf");
        knownMimeTypes.put("etx", "text/x-setext");
        knownMimeTypes.put("evy", "application/envoy");
        knownMimeTypes.put("exe", defaultMimeType);
        knownMimeTypes.put("exi", "application/exi");
        knownMimeTypes.put("ext", "application/vnd.novadigm.ext");
        knownMimeTypes.put("ez2", "application/vnd.ezpix-album");
        knownMimeTypes.put("ez3", "application/vnd.ezpix-package");
        knownMimeTypes.put("f", "text/x-fortran");
        knownMimeTypes.put("f4v", "video/x-f4v");
        knownMimeTypes.put("f77", "text/x-fortran");
        knownMimeTypes.put("f90", "text/x-fortran");
        knownMimeTypes.put("fbs", "image/vnd.fastbidsheet");
        knownMimeTypes.put("fcs", "application/vnd.isac.fcs");
        knownMimeTypes.put("fdf", "application/vnd.fdf");
        knownMimeTypes.put("fe_launch", "application/vnd.denovo.fcselayout-link");
        knownMimeTypes.put("fg5", "application/vnd.fujitsu.oasysgp");
        knownMimeTypes.put("fh", "image/x-freehand");
        knownMimeTypes.put("fif", "image/fif");
        knownMimeTypes.put("fig", "application/x-xfig");
        knownMimeTypes.put("fli", "video/fli");
        knownMimeTypes.put("flo", "image/florian");
        knownMimeTypes.put("flv", "video/x-flv");
        knownMimeTypes.put("flw", "application/vnd.kde.kivio");
        knownMimeTypes.put("flx", "text/vnd.fmi.flexstor");
        knownMimeTypes.put("fly", "text/vnd.fly");
        knownMimeTypes.put("fm", "application/vnd.framemaker");
        knownMimeTypes.put("fmf", "video/x-atomic3d-feature");
        knownMimeTypes.put("fnc", "application/vnd.frogans.fnc");
        knownMimeTypes.put("for", "text/x-fortran");
        knownMimeTypes.put("fpx", "image/vnd.fpx");
        knownMimeTypes.put("frl", "application/freeloader");
        knownMimeTypes.put("fsc", "application/vnd.fsc.weblaunch");
        knownMimeTypes.put("fst", "image/vnd.fst");
        knownMimeTypes.put("ftc", "application/vnd.fluxtime.clip");
        knownMimeTypes.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
        knownMimeTypes.put("funk", "audio/make");
        knownMimeTypes.put("fvt", "video/vnd.fvt");
        knownMimeTypes.put("fxp", "application/vnd.adobe.fxp");
        knownMimeTypes.put("fzs", "application/vnd.fuzzysheet");
        knownMimeTypes.put("g", "text/plain");
        knownMimeTypes.put("g2w", "application/vnd.geoplan");
        knownMimeTypes.put("g3", "image/g3fax");
        knownMimeTypes.put("g3w", "application/vnd.geospace");
        knownMimeTypes.put("gac", "application/vnd.groove-account");
        knownMimeTypes.put("gdl", "model/vnd.gdl");
        knownMimeTypes.put("geo", "application/vnd.dynageo");
        knownMimeTypes.put("gex", "application/vnd.geometry-explorer");
        knownMimeTypes.put("ggb", "application/vnd.geogebra.file");
        knownMimeTypes.put("ggt", "application/vnd.geogebra.tool");
        knownMimeTypes.put("ghf", "application/vnd.groove-help");
        knownMimeTypes.put("gif", "image/gif");
        knownMimeTypes.put("gim", "application/vnd.groove-identity-message");
        knownMimeTypes.put("gl", "video/gl");
        knownMimeTypes.put("gmx", "application/vnd.gmx");
        knownMimeTypes.put("gnumeric", "application/x-gnumeric");
        knownMimeTypes.put("gph", "application/vnd.flographit");
        knownMimeTypes.put("gqf", "application/vnd.grafeq");
        knownMimeTypes.put("gram", "application/srgs");
        knownMimeTypes.put("grv", "application/vnd.groove-injector");
        knownMimeTypes.put("grxml", "application/srgs+xml");
        knownMimeTypes.put("gsd", "audio/x-gsm");
        knownMimeTypes.put("gsf", "application/x-font-ghostscript");
        knownMimeTypes.put("gsm", "audio/x-gsm");
        knownMimeTypes.put("gsp", "application/x-gsp");
        knownMimeTypes.put("gss", "application/x-gss");
        knownMimeTypes.put("gtar", "application/x-gtar");
        knownMimeTypes.put("gtm", "application/vnd.groove-tool-message");
        knownMimeTypes.put("gtw", "model/vnd.gtw");
        knownMimeTypes.put("gv", "text/vnd.graphviz");
        knownMimeTypes.put("gxt", "application/vnd.geonext");
        knownMimeTypes.put("gz", "application/x-gzip");
        knownMimeTypes.put("gzip", "application/x-gzip");
        knownMimeTypes.put("h", "text/x-h");
        knownMimeTypes.put("h261", "video/h261");
        knownMimeTypes.put("h263", "video/h263");
        knownMimeTypes.put("h264", "video/h264");
        knownMimeTypes.put("hal", "application/vnd.hal+xml");
        knownMimeTypes.put("hbci", "application/vnd.hbci");
        knownMimeTypes.put("hdf", "application/x-hdf");
        knownMimeTypes.put("help", "application/x-helpfile");
        knownMimeTypes.put("hgl", "application/vnd.hp-hpgl");
        knownMimeTypes.put("hh", "text/x-h");
        knownMimeTypes.put("hlb", "text/x-script");
        knownMimeTypes.put("hlp", "application/hlp");
        knownMimeTypes.put("hpg", "application/vnd.hp-hpgl");
        knownMimeTypes.put("hpgl", "application/vnd.hp-hpgl");
        knownMimeTypes.put("hpid", "application/vnd.hp-hpid");
        knownMimeTypes.put("hps", "application/vnd.hp-hps");
        knownMimeTypes.put("hqx", "application/binhex");
        knownMimeTypes.put("hta", "application/hta");
        knownMimeTypes.put("htc", "text/x-component");
        knownMimeTypes.put("htke", "application/vnd.kenameaapp");
        knownMimeTypes.put("htm", "text/html");
        knownMimeTypes.put("html", "text/html");
        knownMimeTypes.put("htmls", "text/html");
        knownMimeTypes.put("htt", "text/webviewhtml");
        knownMimeTypes.put("htx", "text/html");
        knownMimeTypes.put("hvd", "application/vnd.yamaha.hv-dic");
        knownMimeTypes.put("hvp", "application/vnd.yamaha.hv-voice");
        knownMimeTypes.put("hvs", "application/vnd.yamaha.hv-script");
        knownMimeTypes.put("i2g", "application/vnd.intergeo");
        knownMimeTypes.put("icc", "application/vnd.iccprofile");
        knownMimeTypes.put("ice", "x-conference/x-cooltalk");
        knownMimeTypes.put("ico", "image/x-icon");
        knownMimeTypes.put("ics", "text/calendar");
        knownMimeTypes.put("idc", "text/plain");
        knownMimeTypes.put("ief", "image/ief");
        knownMimeTypes.put("iefs", "image/ief");
        knownMimeTypes.put("ifm", "application/vnd.shana.informed.formdata");
        knownMimeTypes.put("iges", "application/iges");
        knownMimeTypes.put("igl", "application/vnd.igloader");
        knownMimeTypes.put("igm", "application/vnd.insors.igm");
        knownMimeTypes.put("igs", "application/iges");
        knownMimeTypes.put("igx", "application/vnd.micrografx.igx");
        knownMimeTypes.put("iif", "application/vnd.shana.informed.interchange");
        knownMimeTypes.put("ima", "application/x-ima");
        knownMimeTypes.put("imap", "application/x-httpd-imap");
        knownMimeTypes.put("imp", "application/vnd.accpac.simply.imp");
        knownMimeTypes.put("ims", "application/vnd.ms-ims");
        knownMimeTypes.put("inf", "application/inf");
        knownMimeTypes.put("ins", "application/x-internett-signup");
        knownMimeTypes.put("ip", "application/x-ip2");
        knownMimeTypes.put("ipfix", "application/ipfix");
        knownMimeTypes.put("ipk", "application/vnd.shana.informed.package");
        knownMimeTypes.put("irm", "application/vnd.ibm.rights-management");
        knownMimeTypes.put("irp", "application/vnd.irepository.package+xml");
        knownMimeTypes.put("isu", "video/x-isvideo");
        knownMimeTypes.put("it", "audio/it");
        knownMimeTypes.put("itp", "application/vnd.shana.informed.formtemplate");
        knownMimeTypes.put("iv", "application/x-inventor");
        knownMimeTypes.put("ivp", "application/vnd.immervision-ivp");
        knownMimeTypes.put("ivr", "i-world/i-vrml");
        knownMimeTypes.put("ivu", "application/vnd.immervision-ivu");
        knownMimeTypes.put("ivy", "application/x-livescreen");
        knownMimeTypes.put("jad", "text/vnd.sun.j2me.app-descriptor");
        knownMimeTypes.put("jam", "audio/x-jam");
        knownMimeTypes.put("jar", "application/java-archive");
        knownMimeTypes.put("jav", "text/x-java-source");
        knownMimeTypes.put("java", "text/x-java-source");
        knownMimeTypes.put("jcm", "application/x-java-commerce");
        knownMimeTypes.put("jfif", "image/jpeg");
        knownMimeTypes.put("jfif-tbnl", "image/jpeg");
        knownMimeTypes.put("jisp", "application/vnd.jisp");
        knownMimeTypes.put("jlt", "application/vnd.hp-jlyt");
        knownMimeTypes.put("jnlp", "application/x-java-jnlp-file");
        knownMimeTypes.put("joda", "application/vnd.joost.joda-archive");
        knownMimeTypes.put("jpe", "image/jpeg");
        knownMimeTypes.put("jpeg", "image/jpeg");
        knownMimeTypes.put("jpg", "image/jpeg");
        knownMimeTypes.put("jpgv", "video/jpeg");
        knownMimeTypes.put("jpm", "video/jpm");
        knownMimeTypes.put("jps", "image/x-jps");
        knownMimeTypes.put("js", "text/javascript");
        knownMimeTypes.put("json", "application/json");
        knownMimeTypes.put("jut", "image/jutvision");
        knownMimeTypes.put("kar", "audio/midi");
        knownMimeTypes.put("karbon", "application/vnd.kde.karbon");
        knownMimeTypes.put("kfo", "application/vnd.kde.kformula");
        knownMimeTypes.put("kia", "application/vnd.kidspiration");
        knownMimeTypes.put("kml", "application/vnd.google-earth.kml+xml");
        knownMimeTypes.put("kmz", "application/vnd.google-earth.kmz");
        knownMimeTypes.put("kne", "application/vnd.kinar");
        knownMimeTypes.put("kon", "application/vnd.kde.kontour");
        knownMimeTypes.put("kpr", "application/vnd.kde.kpresenter");
        knownMimeTypes.put("ksh", "text/x-script.ksh");
        knownMimeTypes.put("ksp", "application/vnd.kde.kspread");
        knownMimeTypes.put("ktx", "image/ktx");
        knownMimeTypes.put("ktz", "application/vnd.kahootz");
        knownMimeTypes.put("kwd", "application/vnd.kde.kword");
        knownMimeTypes.put("la", "audio/nspaudio");
        knownMimeTypes.put("lam", "audio/x-liveaudio");
        knownMimeTypes.put("lasxml", "application/vnd.las.las+xml");
        knownMimeTypes.put("latex", "application/x-latex");
        knownMimeTypes.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
        knownMimeTypes.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
        knownMimeTypes.put("les", "application/vnd.hhe.lesson-player");
        knownMimeTypes.put("lha", "application/lha");
        knownMimeTypes.put("lhx", defaultMimeType);
        knownMimeTypes.put("link66", "application/vnd.route66.link66+xml");
        knownMimeTypes.put("list", "text/plain");
        knownMimeTypes.put("lma", "audio/nspaudio");
        knownMimeTypes.put("log", "text/plain");
        knownMimeTypes.put("lrm", "application/vnd.ms-lrm");
        knownMimeTypes.put("lsp", "text/x-script.lisp");
        knownMimeTypes.put("lst", "text/plain");
        knownMimeTypes.put("lsx", "text/x-la-asf");
        knownMimeTypes.put("ltf", "application/vnd.frogans.ltf");
        knownMimeTypes.put("ltx", "application/x-latex");
        knownMimeTypes.put("lvp", "audio/vnd.lucent.voice");
        knownMimeTypes.put("lwp", "application/vnd.lotus-wordpro");
        knownMimeTypes.put("lzh", "application/x-lzh");
        knownMimeTypes.put("lzx", "application/lzx");
        knownMimeTypes.put("m", "text/x-m");
        knownMimeTypes.put("m1v", "video/mpeg");
        knownMimeTypes.put("m21", "application/mp21");
        knownMimeTypes.put("m2a", "audio/mpeg");
        knownMimeTypes.put("m2v", "video/mpeg");
        knownMimeTypes.put("m3u", "audio/x-mpegurl");
        knownMimeTypes.put("m3u8", "application/vnd.apple.mpegurl");
        knownMimeTypes.put("m4v", "video/x-m4v");
        knownMimeTypes.put("ma", "application/mathematica");
        knownMimeTypes.put("mads", "application/mads+xml");
        knownMimeTypes.put("mag", "application/vnd.ecowin.chart");
        knownMimeTypes.put("man", "application/x-troff-man");
        knownMimeTypes.put("map", "application/x-navimap");
        knownMimeTypes.put("mar", "text/plain");
        knownMimeTypes.put("mathml", "application/mathml+xml");
        knownMimeTypes.put("mbd", "application/mbedlet");
        knownMimeTypes.put("mbk", "application/vnd.mobius.mbk");
        knownMimeTypes.put("mbox", "application/mbox");
        knownMimeTypes.put("mc$", "application/x-magic-cap-package-1.0");
        knownMimeTypes.put("mc1", "application/vnd.medcalcdata");
        knownMimeTypes.put("mcd", "application/mcad");
        knownMimeTypes.put("mcf", "image/vasa");
        knownMimeTypes.put("mcp", "application/netmc");
        knownMimeTypes.put("mcurl", "text/vnd.curl.mcurl");
        knownMimeTypes.put("mdb", "application/x-msaccess");
        knownMimeTypes.put("mdi", "image/vnd.ms-modi");
        knownMimeTypes.put("me", "application/x-troff-me");
        knownMimeTypes.put("meta4", "application/metalink4+xml");
        knownMimeTypes.put("mets", "application/mets+xml");
        knownMimeTypes.put("mfm", "application/vnd.mfmp");
        knownMimeTypes.put("mgp", "application/vnd.osgeo.mapguide.package");
        knownMimeTypes.put("mgz", "application/vnd.proteus.magazine");
        knownMimeTypes.put("mht", "message/rfc822");
        knownMimeTypes.put("mhtml", "message/rfc822");
        knownMimeTypes.put("mid", "audio/midi");
        knownMimeTypes.put("midi", "audio/midi");
        knownMimeTypes.put("mif", "application/x-mif");
        knownMimeTypes.put("mime", "message/rfc822");
        knownMimeTypes.put("mj2", "video/mj2");
        knownMimeTypes.put("mjf", "audio/x-vnd.audioexplosion.mjuicemediafile");
        knownMimeTypes.put("mjpg", "video/x-motion-jpeg");
        knownMimeTypes.put("mlp", "application/vnd.dolby.mlp");
        knownMimeTypes.put("mm", "application/x-meme");
        knownMimeTypes.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
        knownMimeTypes.put("mme", "application/base64");
        knownMimeTypes.put("mmf", "application/vnd.smaf");
        knownMimeTypes.put("mmr", "image/vnd.fujixerox.edmics-mmr");
        knownMimeTypes.put("mny", "application/x-msmoney");
        knownMimeTypes.put("mod", "audio/mod");
        knownMimeTypes.put("mods", "application/mods+xml");
        knownMimeTypes.put("moov", "video/quicktime");
        knownMimeTypes.put("mov", "video/quicktime");
        knownMimeTypes.put("movie", "video/x-sgi-movie");
        knownMimeTypes.put("mp2", "audio/mpeg");
        knownMimeTypes.put("mp3", "audio/mpeg3");
        knownMimeTypes.put("mp4", "video/mp4");
        knownMimeTypes.put("mp4a", "audio/mp4");
        knownMimeTypes.put("mpa", "audio/mpeg");
        knownMimeTypes.put("mpc", "application/vnd.mophun.certificate");
        knownMimeTypes.put("mpc", "application/x-project");
        knownMimeTypes.put("mpe", "video/mpeg");
        knownMimeTypes.put("mpeg", "video/mpeg");
        knownMimeTypes.put("mpg", "video/mpeg");
        knownMimeTypes.put("mpga", "audio/mpeg");
        knownMimeTypes.put("mpkg", "application/vnd.apple.installer+xml");
        knownMimeTypes.put("mpm", "application/vnd.blueice.multipass");
        knownMimeTypes.put("mpn", "application/vnd.mophun.application");
        knownMimeTypes.put("mpp", "application/vnd.ms-project");
        knownMimeTypes.put("mpt", "application/x-project");
        knownMimeTypes.put("mpv", "application/x-project");
        knownMimeTypes.put("mpx", "application/x-project");
        knownMimeTypes.put("mpy", "application/vnd.ibm.minipay");
        knownMimeTypes.put("mqy", "application/vnd.mobius.mqy");
        knownMimeTypes.put("mrc", "application/marc");
        knownMimeTypes.put("mrcx", "application/marcxml+xml");
        knownMimeTypes.put("ms", "application/x-troff-ms");
        knownMimeTypes.put("mscml", "application/mediaservercontrol+xml");
        knownMimeTypes.put("mseq", "application/vnd.mseq");
        knownMimeTypes.put("msf", "application/vnd.epson.msf");
        knownMimeTypes.put("msh", "model/mesh");
        knownMimeTypes.put("msl", "application/vnd.mobius.msl");
        knownMimeTypes.put("msty", "application/vnd.muvee.style");
        knownMimeTypes.put("mts", "model/vnd.mts");
        knownMimeTypes.put("mus", "application/vnd.musician");
        knownMimeTypes.put("musicxml", "application/vnd.recordare.musicxml+xml");
        knownMimeTypes.put("mv", "video/x-sgi-movie");
        knownMimeTypes.put("mvb", "application/x-msmediaview");
        knownMimeTypes.put("mwf", "application/vnd.mfer");
        knownMimeTypes.put("mxf", "application/mxf");
        knownMimeTypes.put("mxl", "application/vnd.recordare.musicxml");
        knownMimeTypes.put("mxml", "application/xv+xml");
        knownMimeTypes.put("mxs", "application/vnd.triscape.mxs");
        knownMimeTypes.put("mxu", "video/vnd.mpegurl");
        knownMimeTypes.put("my", "audio/make");
        knownMimeTypes.put("mzz", "application/x-vnd.audioexplosion.mzz");
        knownMimeTypes.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
        knownMimeTypes.put("n3", "text/n3");
        knownMimeTypes.put("nap", "image/naplps");
        knownMimeTypes.put("naplps", "image/naplps");
        knownMimeTypes.put("nbp", "application/vnd.wolfram.player");
        knownMimeTypes.put("nc", "application/x-netcdf");
        knownMimeTypes.put("ncm", "application/vnd.nokia.configuration-message");
        knownMimeTypes.put("ncx", "application/x-dtbncx+xml");
        knownMimeTypes.put("ngdat", "application/vnd.nokia.n-gage.data");
        knownMimeTypes.put("nif", "image/x-niff");
        knownMimeTypes.put("niff", "image/x-niff");
        knownMimeTypes.put("nix", "application/x-mix-transfer");
        knownMimeTypes.put("nlu", "application/vnd.neurolanguage.nlu");
        knownMimeTypes.put("nml", "application/vnd.enliven");
        knownMimeTypes.put("nnd", "application/vnd.noblenet-directory");
        knownMimeTypes.put("nns", "application/vnd.noblenet-sealer");
        knownMimeTypes.put("nnw", "application/vnd.noblenet-web");
        knownMimeTypes.put("npx", "image/vnd.net-fpx");
        knownMimeTypes.put("nsc", "application/x-conference");
        knownMimeTypes.put("nsf", "application/vnd.lotus-notes");
        knownMimeTypes.put("nvd", "application/x-navidoc");
        knownMimeTypes.put("o", defaultMimeType);
        knownMimeTypes.put("oa2", "application/vnd.fujitsu.oasys2");
        knownMimeTypes.put("oa3", "application/vnd.fujitsu.oasys3");
        knownMimeTypes.put("oas", "application/vnd.fujitsu.oasys");
        knownMimeTypes.put("obd", "application/x-msbinder");
        knownMimeTypes.put("oda", "application/oda");
        knownMimeTypes.put("odb", "application/vnd.oasis.opendocument.database");
        knownMimeTypes.put("odc", "application/vnd.oasis.opendocument.chart");
        knownMimeTypes.put("odf", "application/vnd.oasis.opendocument.formula");
        knownMimeTypes.put("odft", "application/vnd.oasis.opendocument.formula-template");
        knownMimeTypes.put("odg", "application/vnd.oasis.opendocument.graphics");
        knownMimeTypes.put("odi", "application/vnd.oasis.opendocument.image");
        knownMimeTypes.put("odm", "application/vnd.oasis.opendocument.text-master");
        knownMimeTypes.put("odp", "application/vnd.oasis.opendocument.presentation");
        knownMimeTypes.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        knownMimeTypes.put("odt", "application/vnd.oasis.opendocument.text");
        knownMimeTypes.put("oga", "audio/ogg");
        knownMimeTypes.put("ogv", "video/ogg");
        knownMimeTypes.put("ogx", "application/ogg");
        knownMimeTypes.put("omc", "application/x-omc");
        knownMimeTypes.put("omcd", "application/x-omcdatamaker");
        knownMimeTypes.put("omcr", "application/x-omcregerator");
        knownMimeTypes.put("onetoc", "application/onenote");
        knownMimeTypes.put("opf", "application/oebps-package+xml");
        knownMimeTypes.put("org", "application/vnd.lotus-organizer");
        knownMimeTypes.put("osf", "application/vnd.yamaha.openscoreformat");
        knownMimeTypes.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
        knownMimeTypes.put("otc", "application/vnd.oasis.opendocument.chart-template");
        knownMimeTypes.put("otf", "application/x-font-otf");
        knownMimeTypes.put("otg", "application/vnd.oasis.opendocument.graphics-template");
        knownMimeTypes.put("oth", "application/vnd.oasis.opendocument.text-web");
        knownMimeTypes.put("oti", "application/vnd.oasis.opendocument.image-template");
        knownMimeTypes.put("otp", "application/vnd.oasis.opendocument.presentation-template");
        knownMimeTypes.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        knownMimeTypes.put("ott", "application/vnd.oasis.opendocument.text-template");
        knownMimeTypes.put("oxt", "application/vnd.openofficeorg.extension");
        knownMimeTypes.put("p", "text/x-pascal");
        knownMimeTypes.put("p10", "application/pkcs10");
        knownMimeTypes.put("p12", "application/pkcs-12");
        knownMimeTypes.put("p7a", "application/x-pkcs7-signature");
        knownMimeTypes.put("p7b", "application/x-pkcs7-certificates");
        knownMimeTypes.put("p7c", "application/pkcs7-mime");
        knownMimeTypes.put("p7m", "application/pkcs7-mime");
        knownMimeTypes.put("p7r", "application/x-pkcs7-certreqresp");
        knownMimeTypes.put("p7s", "application/pkcs7-signature");
        knownMimeTypes.put("p8", "application/pkcs8");
        knownMimeTypes.put("par", "text/plain-bas");
        knownMimeTypes.put("part", "application/pro_eng");
        knownMimeTypes.put("pas", "text/pascal");
        knownMimeTypes.put("paw", "application/vnd.pawaafile");
        knownMimeTypes.put("pbd", "application/vnd.powerbuilder6");
        knownMimeTypes.put("pbm", "image/x-portable-bitmap");
        knownMimeTypes.put("pcf", "application/x-font-pcf");
        knownMimeTypes.put("pcl", "application/x-pcl");
        knownMimeTypes.put("pclxl", "application/vnd.hp-pclxl");
        knownMimeTypes.put("pct", "image/x-pict");
        knownMimeTypes.put("pcurl", "application/vnd.curl.pcurl");
        knownMimeTypes.put("pcx", "image/x-pcx");
        knownMimeTypes.put("pdb", "application/vnd.palm");
        knownMimeTypes.put("pdf", "application/pdf");
        knownMimeTypes.put("pfa", "application/x-font-type1");
        knownMimeTypes.put("pfr", "application/font-tdpfr");
        knownMimeTypes.put("pfunk", "audio/make");
        knownMimeTypes.put("pgm", "image/x-portable-greymap");
        knownMimeTypes.put("pgn", "application/x-chess-pgn");
        knownMimeTypes.put("pgp", "application/pgp-signature");
        knownMimeTypes.put("pic", "image/pict");
        knownMimeTypes.put("pict", "image/pict");
        knownMimeTypes.put("pkg", "application/x-newton-compatible-pkg");
        knownMimeTypes.put("pki", "application/pkixcmp");
        knownMimeTypes.put("pkipath", "application/pkix-pkipath");
        knownMimeTypes.put("pko", "application/vnd.ms-pki.pko");
        knownMimeTypes.put("pl", "text/x-script.perl");
        knownMimeTypes.put("plb", "application/vnd.3gpp.pic-bw-large");
        knownMimeTypes.put("plc", "application/vnd.mobius.plc");
        knownMimeTypes.put("plf", "application/vnd.pocketlearn");
        knownMimeTypes.put("pls", "application/pls+xml");
        knownMimeTypes.put("plx", "application/x-pixclscript");
        knownMimeTypes.put("pm", "text/x-script.perl-module");
        knownMimeTypes.put("pm4", "application/x-pagemaker");
        knownMimeTypes.put("pm5", "application/x-pagemaker");
        knownMimeTypes.put("pml", "application/vnd.ctc-posml");
        knownMimeTypes.put("png", "image/png");
        knownMimeTypes.put("pnm", "image/x-portable-anymap");
        knownMimeTypes.put("portpkg", "application/vnd.macports.portpkg");
        knownMimeTypes.put("pot", "application/vnd.ms-powerpoint");
        knownMimeTypes.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        knownMimeTypes.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        knownMimeTypes.put("pov", "model/x-pov");
        knownMimeTypes.put("ppa", "application/vnd.ms-powerpoint");
        knownMimeTypes.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
        knownMimeTypes.put("ppd", "application/vnd.cups-ppd");
        knownMimeTypes.put("ppm", "image/x-portable-pixmap");
        knownMimeTypes.put("pps", "application/vnd.ms-powerpoint");
        knownMimeTypes.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        knownMimeTypes.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        knownMimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        knownMimeTypes.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        knownMimeTypes.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        knownMimeTypes.put("ppz", "application/mspowerpoint");
        knownMimeTypes.put("prc", "application/x-mobipocket-ebook");
        knownMimeTypes.put("pre", "application/vnd.lotus-freelance");
        knownMimeTypes.put("prf", "application/pics-rules");
        knownMimeTypes.put("prt", "application/pro_eng");
        knownMimeTypes.put("ps", "application/postscript");
        knownMimeTypes.put("psb", "application/vnd.3gpp.pic-bw-small");
        knownMimeTypes.put("psd", "image/vnd.adobe.photoshop");
        knownMimeTypes.put("psf", "application/x-font-linux-psf");
        knownMimeTypes.put("pskcxml", "application/pskc+xml");
        knownMimeTypes.put("ptid", "application/vnd.pvi.ptid1");
        knownMimeTypes.put("pub", "application/x-mspublisher");
        knownMimeTypes.put("pvb", "application/vnd.3gpp.pic-bw-var");
        knownMimeTypes.put("pvu", "paleovu/x-pv");
        knownMimeTypes.put("pwn", "application/vnd.3m.post-it-notes");
        knownMimeTypes.put("pwz", "application/vnd.ms-powerpoint");
        knownMimeTypes.put("py", "text/x-script.phyton");
        knownMimeTypes.put("pya", "audio/vnd.ms-playready.media.pya");
        knownMimeTypes.put("pyc", "application/x-bytecode.python");
        knownMimeTypes.put("pyv", "video/vnd.ms-playready.media.pyv");
        knownMimeTypes.put("qam", "application/vnd.epson.quickanime");
        knownMimeTypes.put("qbo", "application/vnd.intu.qbo");
        knownMimeTypes.put("qcp", "audio/vnd.qcelp");
        knownMimeTypes.put("qd3", "x-world/x-3dmf");
        knownMimeTypes.put("qd3d", "x-world/x-3dmf");
        knownMimeTypes.put("qfx", "application/vnd.intu.qfx");
        knownMimeTypes.put("qif", "image/x-quicktime");
        knownMimeTypes.put("qps", "application/vnd.publishare-delta-tree");
        knownMimeTypes.put("qt", "video/quicktime");
        knownMimeTypes.put("qtc", "video/x-qtc");
        knownMimeTypes.put("qti", "image/x-quicktime");
        knownMimeTypes.put("qtif", "image/x-quicktime");
        knownMimeTypes.put("qxd", "application/vnd.quark.quarkxpress");
        knownMimeTypes.put("ra", "audio/x-realaudio");
        knownMimeTypes.put("ram", "audio/x-pn-realaudio");
        knownMimeTypes.put("rar", "application/x-rar-compressed");
        knownMimeTypes.put("ras", "image/x-cmu-raster");
        knownMimeTypes.put("rast", "image/cmu-raster");
        knownMimeTypes.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
        knownMimeTypes.put("rdf", "application/rdf+xml");
        knownMimeTypes.put("rdz", "application/vnd.data-vision.rdz");
        knownMimeTypes.put("rep", "application/vnd.businessobjects");
        knownMimeTypes.put("res", "application/x-dtbresource+xml");
        knownMimeTypes.put("rexx", "text/x-script.rexx");
        knownMimeTypes.put("rf", "image/vnd.rn-realflash");
        knownMimeTypes.put("rgb", "image/x-rgb");
        knownMimeTypes.put("rif", "application/reginfo+xml");
        knownMimeTypes.put("rip", "audio/vnd.rip");
        knownMimeTypes.put("rl", "application/resource-lists+xml");
        knownMimeTypes.put("rlc", "image/vnd.fujixerox.edmics-rlc");
        knownMimeTypes.put("rld", "application/resource-lists-diff+xml");
        knownMimeTypes.put("rm", "audio/x-pn-realaudio");
        knownMimeTypes.put("rmi", "audio/mid");
        knownMimeTypes.put("rmm", "audio/x-pn-realaudio");
        knownMimeTypes.put("rmp", "audio/x-pn-realaudio-plugin");
        knownMimeTypes.put("rms", "application/vnd.jcp.javame.midlet-rms");
        knownMimeTypes.put("rnc", "application/relax-ng-compact-syntax");
        knownMimeTypes.put("rng", "application/ringing-tones");
        knownMimeTypes.put("rnx", "application/vnd.rn-realplayer");
        knownMimeTypes.put("roff", "application/x-troff");
        knownMimeTypes.put("rp", "image/vnd.rn-realpix");
        knownMimeTypes.put("rp9", "application/vnd.cloanto.rp9");
        knownMimeTypes.put("rpm", "audio/x-pn-realaudio-plugin");
        knownMimeTypes.put("rpss", "application/vnd.nokia.radio-presets");
        knownMimeTypes.put("rpst", "application/vnd.nokia.radio-preset");
        knownMimeTypes.put("rq", "application/sparql-query");
        knownMimeTypes.put("rs", "application/rls-services+xml");
        knownMimeTypes.put("rsd", "application/rsd+xml");
        knownMimeTypes.put("rss", "application/rss+xml");
        knownMimeTypes.put("rt", "text/richtext");
        knownMimeTypes.put("rtf", "application/rtf");
        knownMimeTypes.put("rtx", "text/richtext");
        knownMimeTypes.put("rv", "video/vnd.rn-realvideo");
        knownMimeTypes.put("s", "text/x-asm");
        knownMimeTypes.put("s3m", "audio/s3m");
        knownMimeTypes.put("saf", "application/vnd.yamaha.smaf-audio");
        knownMimeTypes.put("saveme", defaultMimeType);
        knownMimeTypes.put("sbk", "application/x-tbook");
        knownMimeTypes.put("sbml", "application/sbml+xml");
        knownMimeTypes.put("sc", "application/vnd.ibm.secure-container");
        knownMimeTypes.put("scd", "application/x-msschedule");
        knownMimeTypes.put("scm", "application/x-lotusscreencam");
        knownMimeTypes.put("scq", "application/scvp-cv-request");
        knownMimeTypes.put("scs", "application/scvp-cv-response");
        knownMimeTypes.put("scurl", "text/vnd.curl.scurl");
        knownMimeTypes.put("sda", "application/vnd.stardivision.draw");
        knownMimeTypes.put("sdc", "application/vnd.stardivision.calc");
        knownMimeTypes.put("sdd", "application/vnd.stardivision.impress");
        knownMimeTypes.put("sdkm", "application/vnd.solent.sdkm+xml");
        knownMimeTypes.put("sdml", "text/plain");
        knownMimeTypes.put("sdp", "application/sdp");
        knownMimeTypes.put("sdr", "application/sounder");
        knownMimeTypes.put("sdw", "application/vnd.stardivision.writer");
        knownMimeTypes.put("sea", "application/sea");
        knownMimeTypes.put("see", "application/vnd.seemail");
        knownMimeTypes.put("seed", "application/vnd.fdsn.seed");
        knownMimeTypes.put("sema", "application/vnd.sema");
        knownMimeTypes.put("semd", "application/vnd.semd");
        knownMimeTypes.put("semf", "application/vnd.semf");
        knownMimeTypes.put("ser", "application/java-serialized-object");
        knownMimeTypes.put("set", "application/set");
        knownMimeTypes.put("setpay", "application/set-payment-initiation");
        knownMimeTypes.put("setreg", "application/set-registration-initiation");
        knownMimeTypes.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
        knownMimeTypes.put("sfs", "application/vnd.spotfire.sfs");
        knownMimeTypes.put("sgl", "application/vnd.stardivision.writer-global");
        knownMimeTypes.put("sgm", "text/sgml");
        knownMimeTypes.put("sgml", "text/sgml");
        knownMimeTypes.put("sh", "text/x-script.sh");
        knownMimeTypes.put("shar", "application/x-shar");
        knownMimeTypes.put("shf", "application/shf+xml");
        knownMimeTypes.put("shtml", "text/html");
        knownMimeTypes.put("sid", "audio/x-psid");
        knownMimeTypes.put("sis", "application/vnd.symbian.install");
        knownMimeTypes.put("sit", "application/x-stuffit");
        knownMimeTypes.put("sitx", "application/x-stuffitx");
        knownMimeTypes.put("skd", "application/x-koan");
        knownMimeTypes.put("skm", "application/x-koan");
        knownMimeTypes.put("skp", "application/x-koan");
        knownMimeTypes.put("skt", "application/x-koan");
        knownMimeTypes.put("sl", "application/x-seelogo");
        knownMimeTypes.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
        knownMimeTypes.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
        knownMimeTypes.put("slt", "application/vnd.epson.salt");
        knownMimeTypes.put("sm", "application/vnd.stepmania.stepchart");
        knownMimeTypes.put("smi", "application/smil+xml");
        knownMimeTypes.put("smil", "application/smil");
        knownMimeTypes.put("snd", "audio/basic");
        knownMimeTypes.put("snf", "application/x-font-snf");
        knownMimeTypes.put("sol", "application/solids");
        knownMimeTypes.put("spc", "text/x-speech");
        knownMimeTypes.put("spf", "application/vnd.yamaha.smaf-phrase");
        knownMimeTypes.put("spl", "application/futuresplash");
        knownMimeTypes.put("spot", "text/vnd.in3d.spot");
        knownMimeTypes.put("spp", "application/scvp-vp-response");
        knownMimeTypes.put("spq", "application/scvp-vp-request");
        knownMimeTypes.put("spr", "application/x-sprite");
        knownMimeTypes.put("sprite", "application/x-sprite");
        knownMimeTypes.put("src", "application/x-wais-source");
        knownMimeTypes.put("sru", "application/sru+xml");
        knownMimeTypes.put("srx", "application/sparql-results+xml");
        knownMimeTypes.put("sse", "application/vnd.kodak-descriptor");
        knownMimeTypes.put("ssf", "application/vnd.epson.ssf");
        knownMimeTypes.put("ssi", "text/x-server-parsed-html");
        knownMimeTypes.put("ssm", "application/streamingmedia");
        knownMimeTypes.put("ssml", "application/ssml+xml");
        knownMimeTypes.put("sst", "application/vnd.ms-pki.certstore");
        knownMimeTypes.put("st", "application/vnd.sailingtracker.track");
        knownMimeTypes.put("stc", "application/vnd.sun.xml.calc.template");
        knownMimeTypes.put("std", "application/vnd.sun.xml.draw.template");
        knownMimeTypes.put("step", "application/step");
        knownMimeTypes.put("stf", "application/vnd.wt.stf");
        knownMimeTypes.put("sti", "application/vnd.sun.xml.impress.template");
        knownMimeTypes.put("stk", "application/hyperstudio");
        knownMimeTypes.put("stl", "application/sla");
        knownMimeTypes.put("stp", "application/step");
        knownMimeTypes.put("str", "application/vnd.pg.format");
        knownMimeTypes.put("stw", "application/vnd.sun.xml.writer.template");
        knownMimeTypes.put("sub", "image/vnd.dvb.subtitle");
        knownMimeTypes.put("sus", "application/vnd.sus-calendar");
        knownMimeTypes.put("sv4cpio", "application/x-sv4cpio");
        knownMimeTypes.put("sv4crc", "application/x-sv4crc");
        knownMimeTypes.put("svc", "application/vnd.dvb.service");
        knownMimeTypes.put("svd", "application/vnd.svd");
        knownMimeTypes.put("svf", "image/x-dwg");
        knownMimeTypes.put("svg", "image/svg+xml");
        knownMimeTypes.put("svr", "application/x-world");
        knownMimeTypes.put("swf", "application/x-shockwave-flash");
        knownMimeTypes.put("swi", "application/vnd.aristanetworks.swi");
        knownMimeTypes.put("sxc", "application/vnd.sun.xml.calc");
        knownMimeTypes.put("sxd", "application/vnd.sun.xml.draw");
        knownMimeTypes.put("sxg", "application/vnd.sun.xml.writer.global");
        knownMimeTypes.put("sxi", "application/vnd.sun.xml.impress");
        knownMimeTypes.put("sxm", "application/vnd.sun.xml.math");
        knownMimeTypes.put("sxw", "application/vnd.sun.xml.writer");
        knownMimeTypes.put("t", "text/troff");
        knownMimeTypes.put("talk", "text/x-speech");
        knownMimeTypes.put("tao", "application/vnd.tao.intent-module-archive");
        knownMimeTypes.put("tar", "application/x-tar");
        knownMimeTypes.put("tbk", "application/toolbook");
        knownMimeTypes.put("tcap", "application/vnd.3gpp2.tcap");
        knownMimeTypes.put("tcl", "text/x-script.tcl");
        knownMimeTypes.put("tcsh", "text/x-script.tcsh");
        knownMimeTypes.put("teacher", "application/vnd.smart.teacher");
        knownMimeTypes.put("tei", "application/tei+xml");
        knownMimeTypes.put("tex", "application/x-tex");
        knownMimeTypes.put("texi", "application/x-texinfo");
        knownMimeTypes.put("texinfo", "application/x-texinfo");
        knownMimeTypes.put("text", "text/plain");
        knownMimeTypes.put("tfi", "application/thraud+xml");
        knownMimeTypes.put("tfm", "application/x-tex-tfm");
        knownMimeTypes.put("tgz", "application/x-compressed");
        knownMimeTypes.put("thmx", "application/vnd.ms-officetheme");
        knownMimeTypes.put("tif", "image/tiff");
        knownMimeTypes.put("tiff", "image/tiff");
        knownMimeTypes.put("tmo", "application/vnd.tmobile-livetv");
        knownMimeTypes.put("torrent", "application/x-bittorrent");
        knownMimeTypes.put("tpl", "application/vnd.groove-tool-template");
        knownMimeTypes.put("tpt", "application/vnd.trid.tpt");
        knownMimeTypes.put("tr", "application/x-troff");
        knownMimeTypes.put("tra", "application/vnd.trueapp");
        knownMimeTypes.put("trm", "application/x-msterminal");
        knownMimeTypes.put("tsd", "application/timestamped-data");
        knownMimeTypes.put("tsi", "audio/tsp-audio");
        knownMimeTypes.put("tsp", "audio/tsplayer");
        knownMimeTypes.put("tsv", "text/tab-separated-values");
        knownMimeTypes.put("ttf", "application/x-font-ttf");
        knownMimeTypes.put("ttl", "text/turtle");
        knownMimeTypes.put("turbot", "image/florian");
        knownMimeTypes.put("twd", "application/vnd.simtech-mindmapper");
        knownMimeTypes.put("txd", "application/vnd.genomatix.tuxedo");
        knownMimeTypes.put("txf", "application/vnd.mobius.txf");
        knownMimeTypes.put("txt", "text/plain");
        knownMimeTypes.put("ufd", "application/vnd.ufdl");
        knownMimeTypes.put("uil", "text/x-uil");
        knownMimeTypes.put("umj", "application/vnd.umajin");
        knownMimeTypes.put("uni", "text/uri-list");
        knownMimeTypes.put("unis", "text/uri-list");
        knownMimeTypes.put("unityweb", "application/vnd.unity");
        knownMimeTypes.put("unv", "application/i-deas");
        knownMimeTypes.put("uoml", "application/vnd.uoml+xml");
        knownMimeTypes.put("uri", "text/uri-list");
        knownMimeTypes.put("uris", "text/uri-list");
        knownMimeTypes.put("ustar", "application/x-ustar");
        knownMimeTypes.put("utz", "application/vnd.uiq.theme");
        knownMimeTypes.put("uu", "text/x-uuencode");
        knownMimeTypes.put("uue", "text/x-uuencode");
        knownMimeTypes.put("uva", "audio/vnd.dece.audio");
        knownMimeTypes.put("uvh", "video/vnd.dece.hd");
        knownMimeTypes.put("uvi", "image/vnd.dece.graphic");
        knownMimeTypes.put("uvm", "video/vnd.dece.mobile");
        knownMimeTypes.put("uvp", "video/vnd.dece.pd");
        knownMimeTypes.put("uvs", "video/vnd.dece.sd");
        knownMimeTypes.put("uvu", "video/vnd.uvvu.mp4");
        knownMimeTypes.put("uvv", "video/vnd.dece.video");
        knownMimeTypes.put("vcd", "application/x-cdlink");
        knownMimeTypes.put("vcf", "text/x-vcard");
        knownMimeTypes.put("vcg", "application/vnd.groove-vcard");
        knownMimeTypes.put("vcs", "text/x-vcalendar");
        knownMimeTypes.put("vcx", "application/vnd.vcx");
        knownMimeTypes.put("vda", "application/vda");
        knownMimeTypes.put("vdo", "video/vdo");
        knownMimeTypes.put("vew", "application/groupwise");
        knownMimeTypes.put("vis", "application/vnd.visionary");
        knownMimeTypes.put("viv", "video/vivo");
        knownMimeTypes.put("vivo", "video/vivo");
        knownMimeTypes.put("vmd", "application/vocaltec-media-desc");
        knownMimeTypes.put("vmf", "application/vocaltec-media-file");
        knownMimeTypes.put("voc", "audio/voc");
        knownMimeTypes.put("vos", "video/vosaic");
        knownMimeTypes.put("vox", "audio/voxware");
        knownMimeTypes.put("vqe", "audio/x-twinvq-plugin");
        knownMimeTypes.put("vqf", "audio/x-twinvq");
        knownMimeTypes.put("vql", "audio/x-twinvq-plugin");
        knownMimeTypes.put("vrml", "application/x-vrml");
        knownMimeTypes.put("vrt", "x-world/x-vrt");
        knownMimeTypes.put("vsd", "application/x-visio");
        knownMimeTypes.put("vsf", "application/vnd.vsf");
        knownMimeTypes.put("vst", "application/x-visio");
        knownMimeTypes.put("vsw", "application/x-visio");
        knownMimeTypes.put("vtu", "model/vnd.vtu");
        knownMimeTypes.put("vxml", "application/voicexml+xml");
        knownMimeTypes.put("w60", "application/wordperfect6.0");
        knownMimeTypes.put("w61", "application/wordperfect6.1");
        knownMimeTypes.put("w6w", "application/msword");
        knownMimeTypes.put("wad", "application/x-doom");
        knownMimeTypes.put("wav", "audio/wav");
        knownMimeTypes.put("wax", "audio/x-ms-wax");
        knownMimeTypes.put("wb1", "application/x-qpro");
        knownMimeTypes.put("wbmp", "image/vnd.wap.wbmp");
        knownMimeTypes.put("wbs", "application/vnd.criticaltools.wbs+xml");
        knownMimeTypes.put("wbxml", "application/vnd.wap.wbxml");
        knownMimeTypes.put("web", "application/vnd.xara");
        knownMimeTypes.put("weba", "audio/webm");
        knownMimeTypes.put("webm", "video/webm");
        knownMimeTypes.put("webp", "image/webp");
        knownMimeTypes.put("wg", "application/vnd.pmi.widget");
        knownMimeTypes.put("wgt", "application/widget");
        knownMimeTypes.put("wiz", "application/msword");
        knownMimeTypes.put("wk1", "application/x-123");
        knownMimeTypes.put("wm", "video/x-ms-wm");
        knownMimeTypes.put("wma", "audio/x-ms-wma");
        knownMimeTypes.put("wmd", "application/x-ms-wmd");
        knownMimeTypes.put("wmf", "application/x-msmetafile");
        knownMimeTypes.put("wml", "text/vnd.wap.wml");
        knownMimeTypes.put("wmlc", "application/vnd.wap.wmlc");
        knownMimeTypes.put("wmls", "text/vnd.wap.wmlscript");
        knownMimeTypes.put("wmlsc", "application/vnd.wap.wmlscriptc");
        knownMimeTypes.put("wmv", "video/x-ms-wmv");
        knownMimeTypes.put("wmx", "video/x-ms-wmx");
        knownMimeTypes.put("wmz", "application/x-ms-wmz");
        knownMimeTypes.put("woff", "application/x-font-woff");
        knownMimeTypes.put("word", "application/msword");
        knownMimeTypes.put("wp", "application/wordperfect");
        knownMimeTypes.put("wp5", "application/wordperfect");
        knownMimeTypes.put("wp6", "application/wordperfect");
        knownMimeTypes.put("wpd", "application/wordperfect");
        knownMimeTypes.put("wpl", "application/vnd.ms-wpl");
        knownMimeTypes.put("wps", "application/vnd.ms-works");
        knownMimeTypes.put("wq1", "application/x-lotus");
        knownMimeTypes.put("wqd", "application/vnd.wqd");
        knownMimeTypes.put("wri", "application/mswrite");
        knownMimeTypes.put("wrl", "application/x-world");
        knownMimeTypes.put("wrz", "model/vrml");
        knownMimeTypes.put("wsc", "text/scriplet");
        knownMimeTypes.put("wsdl", "application/wsdl+xml");
        knownMimeTypes.put("wspolicy", "application/wspolicy+xml");
        knownMimeTypes.put("wsrc", "application/x-wais-source");
        knownMimeTypes.put("wtb", "application/vnd.webturbo");
        knownMimeTypes.put("wtk", "application/x-wintalk");
        knownMimeTypes.put("wvx", "video/x-ms-wvx");
        knownMimeTypes.put("x-png", "image/png");
        knownMimeTypes.put("x3d", "application/vnd.hzn-3d-crossword");
        knownMimeTypes.put("xap", "application/x-silverlight-app");
        knownMimeTypes.put("xar", "application/vnd.xara");
        knownMimeTypes.put("xbap", "application/x-ms-xbap");
        knownMimeTypes.put("xbd", "application/vnd.fujixerox.docuworks.binder");
        knownMimeTypes.put("xbm", "image/x-xbitmap");
        knownMimeTypes.put("xdf", "application/xcap-diff+xml");
        knownMimeTypes.put("xdm", "application/vnd.syncml.dm+xml");
        knownMimeTypes.put("xdp", "application/vnd.adobe.xdp+xml");
        knownMimeTypes.put("xdr", "video/x-amt-demorun");
        knownMimeTypes.put("xdssc", "application/dssc+xml");
        knownMimeTypes.put("xdw", "application/vnd.fujixerox.docuworks");
        knownMimeTypes.put("xenc", "application/xenc+xml");
        knownMimeTypes.put("xer", "application/patch-ops-error+xml");
        knownMimeTypes.put("xfdf", "application/vnd.adobe.xfdf");
        knownMimeTypes.put("xfdl", "application/vnd.xfdl");
        knownMimeTypes.put("xgz", "xgl/drawing");
        knownMimeTypes.put("xhtml", "application/xhtml+xml");
        knownMimeTypes.put("xif", "image/vnd.xiff");
        knownMimeTypes.put("xl", "application/excel");
        knownMimeTypes.put("xla", "application/excel");
        knownMimeTypes.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
        knownMimeTypes.put("xlb", "application/excel");
        knownMimeTypes.put("xlc", "application/excel");
        knownMimeTypes.put("xld", "application/excel");
        knownMimeTypes.put("xlk", "application/excel");
        knownMimeTypes.put("xll", "application/excel");
        knownMimeTypes.put("xlm", "application/excel");
        knownMimeTypes.put("xls", "application/vnd.ms-excel");
        knownMimeTypes.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        knownMimeTypes.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        knownMimeTypes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        knownMimeTypes.put("xlt", "application/excel");
        knownMimeTypes.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        knownMimeTypes.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        knownMimeTypes.put("xlv", "application/excel");
        knownMimeTypes.put("xlw", "application/excel");
        knownMimeTypes.put("xm", "audio/xm");
        knownMimeTypes.put("xml", "text/xml");
        knownMimeTypes.put("xmz", "xgl/movie");
        knownMimeTypes.put("xo", "application/vnd.olpc-sugar");
        knownMimeTypes.put("xop", "application/xop+xml");
        knownMimeTypes.put("xpi", "application/x-xpinstall");
        knownMimeTypes.put("xpix", "application/x-vnd.ls-xpix");
        knownMimeTypes.put("xpm", "image/xpm");
        knownMimeTypes.put("xpr", "application/vnd.is-xpr");
        knownMimeTypes.put("xps", "application/vnd.ms-xpsdocument");
        knownMimeTypes.put("xpw", "application/vnd.intercon.formnet");
        knownMimeTypes.put("xsd", "text/xml");
        knownMimeTypes.put("xslt", "application/xslt+xml");
        knownMimeTypes.put("xsm", "application/vnd.syncml+xml");
        knownMimeTypes.put("xspf", "application/xspf+xml");
        knownMimeTypes.put("xsr", "video/x-amt-showrun");
        knownMimeTypes.put("xul", "application/vnd.mozilla.xul+xml");
        knownMimeTypes.put("xwd", "image/x-xwd");
        knownMimeTypes.put("xyz", "chemical/x-xyz");
        knownMimeTypes.put("yaml", "text/yaml");
        knownMimeTypes.put("yang", "application/yang");
        knownMimeTypes.put("yin", "application/yin+xml");
        knownMimeTypes.put("z", "application/x-compress");
        knownMimeTypes.put("zaz", "application/vnd.zzazz.deck+xml");
        knownMimeTypes.put("zip", "application/zip");
        knownMimeTypes.put("zir", "application/vnd.zul");
        knownMimeTypes.put("zmm", "application/vnd.handheld-entertainment+xml");
        knownMimeTypes.put("zoo", defaultMimeType);
        knownMimeTypes.put("zsh", "text/x-script.zsh");
    }
}

