/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.usage;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.usage.MethodInfo;
import si.nevensrok.common.usage.UsageLoggerConfig;
import si.nevensrok.common.usage.UsageRecorder;

public class UsageCollector
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UsageCollector.class);
    private HashMap<String, MethodInfo> methodInfos = new HashMap();
    private UsageRecorder[] usageRecorders;
    private boolean enableCollecting = true;
    private boolean enableJmx = false;
    private String objectName = this.getClass().getSimpleName();

    public void setUsageRecorder(UsageRecorder usageRecorder) {
        this.usageRecorders = new UsageRecorder[]{usageRecorder};
    }

    public void setUsageRecorders(UsageRecorder[] usageRecorders) {
        this.usageRecorders = usageRecorders;
    }

    public boolean isEnableCollecting() {
        return this.enableCollecting;
    }

    public void setEnableCollecting(boolean enableCollecting) {
        this.enableCollecting = enableCollecting;
    }

    public boolean isEnableJmx() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.usageRecorders == null) {
            throw new IllegalArgumentException("Property 'usageRecorders' is required");
        }
        if (this.enableJmx) {
            try {
                final UsageCollector obj = this;
                final String[] attributeList = new String[]{"enableCollecting"};
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName objectName = new ObjectName(this.getClass().getPackage().getName() + ":type=" + this.objectName);
                mBeanServer.registerMBean(new DynamicMBean(){

                    @Override
                    public AttributeList setAttributes(AttributeList attributes) {
                        for (Attribute attribute : attributes.asList()) {
                            try {
                                this.setAttribute(attribute);
                            }
                            catch (Throwable e) {
                                log.error("Error setting field value", e);
                            }
                        }
                        return attributes;
                    }

                    @Override
                    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
                        try {
                            Field field = obj.getClass().getDeclaredField(attribute.getName());
                            field.setAccessible(true);
                            field.set(obj, attribute.getValue());
                        }
                        catch (Throwable e) {
                            log.error("Error setting field value", e);
                        }
                    }

                    @Override
                    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
                        throw new RuntimeException("Method is not supported");
                    }

                    @Override
                    public MBeanInfo getMBeanInfo() {
                        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[attributeList.length];
                        for (int i = 0; i < attributes.length; ++i) {
                            try {
                                Field field = obj.getClass().getDeclaredField(attributeList[i]);
                                attributes[i] = new MBeanAttributeInfo(attributeList[i], field.getGenericType().getTypeName(), attributeList[i], true, true, field.getGenericType().getTypeName().equals("boolean"));
                                continue;
                            }
                            catch (Throwable e) {
                                log.error("Error generating field info", e);
                            }
                        }
                        MBeanConstructorInfo[] constructors = null;
                        MBeanOperationInfo[] operations = null;
                        MBeanNotificationInfo[] notifications = null;
                        return new MBeanInfo(obj.getClass().getName(), "Usage collector", attributes, constructors, operations, notifications);
                    }

                    @Override
                    public AttributeList getAttributes(String[] attributes) {
                        AttributeList attributeList2 = new AttributeList();
                        for (String attribute : attributes) {
                            try {
                                attributeList2.add(this.getAttribute(attribute));
                            }
                            catch (Throwable e) {
                                log.error("Error retriving field value", e);
                            }
                        }
                        return attributeList2;
                    }

                    @Override
                    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
                        try {
                            Field field = obj.getClass().getDeclaredField(attribute);
                            field.setAccessible(true);
                            return field.get(obj);
                        }
                        catch (Throwable e) {
                            log.error("Error retriving field value", e);
                            return null;
                        }
                    }
                }, objectName);
            }
            catch (Throwable e) {
                log.error("Error exposing bean via JMX", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object logMethodUsage(ProceedingJoinPoint point) throws Throwable {
        MethodInfo methodInfo;
        if (!this.enableCollecting || !this.isTrack(point)) {
            return point.proceed();
        }
        String methodName = this.generateMethodId(point);
        String beanName = this.getBeanName(point);
        Object result = null;
        Throwable error = null;
        long startTime = System.currentTimeMillis();
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            error = e;
        }
        long duration = System.currentTimeMillis() - startTime;
        if (duration < 0L) {
            duration = 0L;
        }
        Serializable serializable = this.methodInfos;
        synchronized (serializable) {
            methodInfo = this.methodInfos.get(methodName);
            if (methodInfo == null) {
                methodInfo = new MethodInfo(methodName, beanName);
                this.methodInfos.put(methodName, methodInfo);
            }
        }
        serializable = methodInfo;
        synchronized (serializable) {
            methodInfo.setCount(methodInfo.getCount() + 1);
            methodInfo.setDuration(methodInfo.getDuration() + duration);
            if (duration < methodInfo.getMinDuration()) {
                methodInfo.setMinDuration(duration);
            }
            if (duration > methodInfo.getMaxDuration()) {
                methodInfo.setMaxDuration(duration);
            }
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCheckpoint() {
        UsageRecorder[] usageRecorderArray = this.methodInfos;
        synchronized (this.methodInfos) {
            ArrayList<MethodInfo> methodInfoList = new ArrayList<MethodInfo>(this.methodInfos.values());
            this.methodInfos.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Collections.sort(methodInfoList, new Comparator<MethodInfo>(){

                @Override
                public int compare(MethodInfo o1, MethodInfo o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            if (!methodInfoList.isEmpty()) {
                for (UsageRecorder usageRecorder : this.usageRecorders) {
                    usageRecorder.logUsageRecords(methodInfoList);
                }
            }
            return;
        }
    }

    private String generateMethodId(ProceedingJoinPoint point) {
        StringBuilder methodId = new StringBuilder();
        methodId.append(point.getTarget().getClass().getName());
        methodId.append("->");
        methodId.append(point.getSignature().getName());
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            methodId.append("(");
            boolean firstParameter = true;
            for (Class clazz : methodSignature.getParameterTypes()) {
                if (firstParameter) {
                    firstParameter = false;
                } else {
                    methodId.append(",");
                }
                methodId.append(clazz.getName());
            }
            methodId.append(")");
        }
        return methodId.toString();
    }

    private boolean isTrack(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof UsageLoggerConfig)) continue;
                UsageLoggerConfig usageLoggerConfig = (UsageLoggerConfig)annotation;
                return usageLoggerConfig.value();
            }
        }
        return true;
    }

    private String getBeanName(ProceedingJoinPoint point) throws Exception {
        try {
            Object target = point.getTarget();
            for (Method method : target.getClass().getMethods()) {
                if (!method.getName().equalsIgnoreCase("getBeanName") || method.getParameterTypes().length != 0) continue;
                return (String)method.invoke(target, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

