/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessenger;
import si.nevensrok.common.network.tcp.DisconnectListener;

public class TcpNetworkConnection
implements NetworkMessenger {
    private static final Logger log = LoggerFactory.getLogger(TcpNetworkConnection.class);
    private boolean active = true;
    private Socket socket;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private Object sendMessageMonitor = new Object();
    private Object messagesMonitor = new Object();
    private LinkedList<NetworkMessage> messages = new LinkedList();
    private DisconnectListener disconnectListener = null;

    protected TcpNetworkConnection(Socket socket) throws Exception {
        this.socket = socket;
    }

    public void setDisconnectListener(DisconnectListener disconnectListener) {
        this.disconnectListener = disconnectListener;
    }

    protected OutputStream openOutputStream(OutputStream outputStream) throws Exception {
        return outputStream;
    }

    protected InputStream openInputStream(InputStream inputStream) throws Exception {
        return inputStream;
    }

    void open() throws Exception {
        this.outputStream = new ObjectOutputStream(this.openOutputStream(this.socket.getOutputStream()));
        this.inputStream = new ObjectInputStream(this.openInputStream(this.socket.getInputStream()));
        Thread readerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (TcpNetworkConnection.this.active) {
                    try {
                        Object obj = TcpNetworkConnection.this.inputStream.readObject();
                        log.trace("Readed object: {}", obj);
                        NetworkMessage networkMessage = new NetworkMessage(TcpNetworkConnection.this.socket.getInetAddress(), TcpNetworkConnection.this.socket.getPort(), obj);
                        Object object = TcpNetworkConnection.this.messagesMonitor;
                        synchronized (object) {
                            TcpNetworkConnection.this.messages.add(networkMessage);
                            TcpNetworkConnection.this.messagesMonitor.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        log.trace("Error reading message", (Throwable)e);
                        TcpNetworkConnection.this.close();
                    }
                }
            }
        };
        readerThread.setDaemon(true);
        readerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.active = false;
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.messagesMonitor;
        synchronized (object) {
            this.messages.clear();
            this.messagesMonitor.notifyAll();
        }
        if (this.disconnectListener != null) {
            this.disconnectListener.disconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Object object) throws NetworkException {
        try {
            log.trace("Sending object {}", object);
            Object object2 = this.sendMessageMonitor;
            synchronized (object2) {
                this.outputStream.writeObject(object);
                this.outputStream.flush();
            }
        }
        catch (Exception e) {
            this.close();
            throw new NetworkException("Error sending message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkMessage receiveMessage() throws NetworkException {
        Object object = this.messagesMonitor;
        synchronized (object) {
            while (this.messages.isEmpty() && this.active) {
                try {
                    this.messagesMonitor.wait();
                }
                catch (Exception exception) {}
            }
            if (this.messages.isEmpty()) {
                throw new NetworkException("Connection closed");
            }
            return this.messages.removeFirst();
        }
    }
}

