/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.tcp;

import java.util.HashMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.common.CacheEventMessage;
import si.nevensrok.common.ehcache.common.FetchObjectMessage;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessenger;

public class TcpMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(TcpMessageHandler.class);
    private boolean active = true;

    public TcpMessageHandler(final CacheManager cacheManager, final NetworkMessenger networkMessenger) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (TcpMessageHandler.this.active) {
                        Ehcache cache;
                        NetworkMessage networkMessage = networkMessenger.receiveMessage();
                        Object data = networkMessage.getData();
                        if (data == null) {
                            log.error("Message data is null");
                            continue;
                        }
                        if (data instanceof CacheEventMessage) {
                            CacheEventMessage cacheEventMessage = (CacheEventMessage)data;
                            log.trace("Cache event message received: {}", (Object)cacheEventMessage);
                            cache = cacheManager.getEhcache(cacheEventMessage.getCacheName());
                            if (cache == null) {
                                log.warn("Cache with name [{}] not found", (Object)cacheEventMessage.getCacheName());
                                continue;
                            }
                            Object key = cacheEventMessage.getKey();
                            Element element = cacheEventMessage.getElement();
                            if (cacheEventMessage.getAction() == CacheEventMessage.Action.PUT) {
                                cache.put(element, true);
                                continue;
                            }
                            if (cacheEventMessage.getAction() == CacheEventMessage.Action.REMOVE) {
                                cache.remove(key, true);
                                continue;
                            }
                            if (cacheEventMessage.getAction() != CacheEventMessage.Action.REMOVE_ALL) continue;
                            cache.removeAll(true);
                            continue;
                        }
                        if (data instanceof FetchObjectMessage) {
                            FetchObjectMessage fetchObjectMessage = (FetchObjectMessage)data;
                            log.trace("Fetch object message received: {}", (Object)fetchObjectMessage);
                            cache = cacheManager.getEhcache(fetchObjectMessage.getCacheName());
                            HashMap<Object, Object> values = new HashMap<Object, Object>();
                            for (Object key : fetchObjectMessage.getKeys()) {
                                Element element = cache.get(key);
                                values.put(key, element.getObjectValue());
                            }
                            networkMessenger.sendMessage(new FetchObjectMessage(values));
                            continue;
                        }
                        log.error("Unsupported message type {}", data.getClass());
                    }
                }
                catch (Exception e) {
                    log.debug("Error handling message", (Throwable)e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void close() {
        this.active = false;
    }
}

