/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.semafor.common.SemaphoreData;
import si.nevensrok.jtekma.semafor.fw.SemaphoreManager;
import si.nevensrok.jtekma.semafor.gui.FightDisplay;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.utils.gui.CredentialsDialog;

public class SemaphoreWindow
extends JFrame
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = -4002413487760635987L;
    private static final Logger log = LoggerFactory.getLogger(SemaphoreWindow.class);
    private Font tatamiNameFont = new Font("SansSerif", 1, 50);
    private ApplicationContext applicationContext;
    private KeyListener keyListener;
    private SemaphoreData semaphoreData;
    private SemaphoreManager semaphoreManager;
    private Object displayMonitor = new Object();
    private JPanel mainPanel = new JPanel();
    private boolean fullScreen = true;
    private String defaultServiceUrl = null;
    private boolean broadcasterEnable = false;
    private int broadcasterPort = 12701;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.semaphoreData.getLocale());
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void setSemaphoreData(SemaphoreData semaphoreData) {
        this.semaphoreData = semaphoreData;
    }

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public void setDefaultServiceUrl(String defaultServiceUrl) {
        this.defaultServiceUrl = defaultServiceUrl;
    }

    public void setBroadcasterEnable(boolean broadcasterEnable) {
        this.broadcasterEnable = broadcasterEnable;
    }

    public void setBroadcasterPort(int broadcasterPort) {
        this.broadcasterPort = broadcasterPort;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
    }

    public SemaphoreWindow() {
        this.setDefaultCloseOperation(0);
        this.setTitle("JTekma2 - semafor");
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.setDefaultFocusTraversalKeys(0, Collections.EMPTY_SET);
        kfm.setDefaultFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SemaphoreWindow.this.applicationContext instanceof AbstractApplicationContext) {
                    AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)SemaphoreWindow.this.applicationContext;
                    abstractApplicationContext.close();
                } else {
                    log.warn("Can't destroy application context. Stopping java proccess");
                    System.exit(0);
                }
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyListener != null) {
            this.addKeyListener(this.keyListener);
        }
        if (this.fullScreen) {
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.resetWindowLocation();
        } else {
            this.setSize(1024, 768);
        }
        final SemaphoreWindow window = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SemaphoreWindow.this.setVisible(true);
                String buildVersion = "";
                ClassPathResource gitFileResurce = new ClassPathResource("/git.properties");
                if (gitFileResurce.exists()) {
                    try {
                        Properties properties = new Properties();
                        properties.load(gitFileResurce.getInputStream());
                        buildVersion = (String)properties.get("git.commit.id.describe");
                    }
                    catch (Exception e) {
                        log.debug("Error reading git build info", e);
                    }
                }
                try {
                    HashMap<String, String> messages = new HashMap<String, String>();
                    messages.put("title", SemaphoreWindow.this.getLanguageText("title.login"));
                    messages.put("url", SemaphoreWindow.this.getLanguageText("text.url"));
                    messages.put("username", SemaphoreWindow.this.getLanguageText("text.username"));
                    messages.put("password", SemaphoreWindow.this.getLanguageText("text.password"));
                    messages.put("login", SemaphoreWindow.this.getLanguageText("text.login"));
                    messages.put("cancel", SemaphoreWindow.this.getLanguageText("text.cancel"));
                    messages.put("buildVersion", SemaphoreWindow.this.getLanguageText("systemInfo.version"));
                    messages.put("buildVersionDisplay", buildVersion);
                    messages.put("defaultServiceUrl", SemaphoreWindow.this.defaultServiceUrl);
                    if (SemaphoreWindow.this.broadcasterEnable) {
                        messages.put("broadcaster.port", String.valueOf(SemaphoreWindow.this.broadcasterPort));
                    }
                    while (true) {
                        try {
                            Credentials credentials;
                            while ((credentials = CredentialsDialog.showDialog((Frame)window, messages)) != null) {
                                if (SemaphoreWindow.this.semaphoreManager.checkLogin(credentials)) {
                                    SemaphoreWindow.this.semaphoreData.setCredentials(credentials);
                                    JOptionPane.showMessageDialog(window, SemaphoreWindow.this.getLanguageText("text.loginSuccess"), SemaphoreWindow.this.getLanguageText("title.info"), 1);
                                    return;
                                }
                                JOptionPane.showMessageDialog(window, SemaphoreWindow.this.getLanguageText("text.invalidCredentials"), SemaphoreWindow.this.getLanguageText("title.error"), 0);
                            }
                        }
                        catch (Exception e) {
                            log.error("Error while cheking login", e);
                            JOptionPane.showMessageDialog(window, SemaphoreWindow.this.getLanguageText("text.errorConnectionToServer"), SemaphoreWindow.this.getLanguageText("title.error"), 0);
                            continue;
                        }
                        break;
                    }
                    if (SemaphoreWindow.this.applicationContext instanceof AbstractApplicationContext) {
                        AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)SemaphoreWindow.this.applicationContext;
                        abstractApplicationContext.close();
                    } else {
                        log.warn("Can't destroy application context. Stopping java proccess");
                        System.exit(0);
                    }
                }
                catch (Exception ex) {
                    log.error("Error while cheking login", ex);
                    JOptionPane.showMessageDialog(window, SemaphoreWindow.this.getLanguageText("text.errorConnectionToServer"), SemaphoreWindow.this.getLanguageText("title.error"), 0);
                }
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SemaphoreWindow.this.setVisible(false);
                SemaphoreWindow.this.dispose();
            }
        });
    }

    public void resetWindowLocation() {
        final Dimension screeenSize = Toolkit.getDefaultToolkit().getScreenSize();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SemaphoreWindow.this.setLocation(0, 0);
                SemaphoreWindow.this.setSize(screeenSize);
            }
        });
    }

    public void displayData(final Integer displayRows, final List<TatamiFightOrder> tatamiFightOrders) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SemaphoreWindow.this.displayMonitor;
                synchronized (object) {
                    Integer rowsNumber = displayRows;
                    if (rowsNumber == null) {
                        rowsNumber = 1;
                    }
                    if (rowsNumber > tatamiFightOrders.size()) {
                        rowsNumber = tatamiFightOrders.size();
                    }
                    if (rowsNumber < 1) {
                        rowsNumber = 1;
                    }
                    Integer tatamisPerRow = (int)Math.ceil((float)tatamiFightOrders.size() / (float)rowsNumber.intValue());
                    SemaphoreWindow.this.remove(SemaphoreWindow.this.mainPanel);
                    SemaphoreWindow.this.mainPanel = new JPanel(new GridLayout(rowsNumber, tatamisPerRow, 5, 5));
                    SemaphoreWindow.this.mainPanel.setBackground(Color.WHITE);
                    for (TatamiFightOrder tatamiFightOrder : tatamiFightOrders) {
                        JPanel tatamiPanel = new JPanel(new BorderLayout());
                        tatamiPanel.setBackground(Color.WHITE);
                        SemaphoreWindow.this.mainPanel.add(tatamiPanel);
                        JLabel tatamiNameLabel = new JLabel(tatamiFightOrder.getTatami().getDisplayText());
                        tatamiNameLabel.setFont(SemaphoreWindow.this.tatamiNameFont);
                        tatamiNameLabel.setHorizontalAlignment(0);
                        tatamiPanel.add((Component)tatamiNameLabel, "North");
                        JPanel centerPanel = new JPanel(new BorderLayout());
                        centerPanel.setBackground(Color.WHITE);
                        tatamiPanel.add((Component)centerPanel, "Center");
                        JPanel fightsPanel = new JPanel(new GridLayout(tatamiFightOrder.getFightOrders().size(), 1, 0, 5));
                        fightsPanel.setBackground(Color.WHITE);
                        centerPanel.add((Component)fightsPanel, "North");
                        JLabel emptyLabel = new JLabel();
                        emptyLabel.setBackground(Color.WHITE);
                        centerPanel.add((Component)emptyLabel, "Center");
                        for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                            FightDisplay fightDisplay = new FightDisplay(fightOrder);
                            fightsPanel.add(fightDisplay);
                        }
                    }
                    SemaphoreWindow.this.add((Component)SemaphoreWindow.this.mainPanel, "Center");
                    SemaphoreWindow.this.revalidate();
                    SemaphoreWindow.this.repaint();
                }
            }
        });
    }
}

