/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageManipulationTool {
    public static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    public static BufferedImage resizeImageKeepRatio(BufferedImage image, int width, int height, Color fillColor) {
        BufferedImage newImage = new BufferedImage(width, height, 2);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth > width) {
            imageHeight = Math.round((float)imageHeight * (float)width / (float)imageWidth);
            imageWidth = width;
        }
        if (imageHeight > height) {
            imageWidth = Math.round((float)imageWidth * (float)height / (float)imageHeight);
            imageHeight = height;
        }
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fillRect(0, 0, width, height);
        }
        int x = Math.round((float)(width - imageWidth) / 2.0f);
        int y = Math.round((float)(height - imageHeight) / 2.0f);
        g.drawImage(image, x, y, imageWidth, imageHeight, null);
        return newImage;
    }

    public static BufferedImage addBackgroundToImage(BufferedImage image, Color color) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        return newImage;
    }

    public static BufferedImage getAsTransparentImage(BufferedImage image, float fill) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int aplha = rgb >> 24 & 0xFF;
                aplha = Math.round((float)aplha * fill);
                aplha = (aplha << 24) + (rgb & 0xFFFFFF);
                newImage.setRGB(x, y, aplha);
            }
        }
        return newImage;
    }

    public static BufferedImage addImageToImage(BufferedImage image, int x, int y, BufferedImage imageToAdd) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.drawImage((Image)imageToAdd, x, y, null);
        return newImage;
    }
}

