/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import java.io.StringWriter;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Layout;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import si.nevensrok.common.logging.AbstractBackgroundAppender;
import si.nevensrok.common.logging.LogItem;

public class CronMailAppender
extends AbstractBackgroundAppender {
    private String hostname;
    private int port = 25;
    private String username;
    private String password;
    private String fromEmail;
    private String toEmail;
    private String cronExpression;
    private int messagesLimit = 1000;
    private boolean useStartTsl = false;
    private boolean trustAllHosts = false;
    private String messageRegex;
    private ThreadPoolTaskScheduler taskScheduler;
    private List<String> messages = new LinkedList<String>();

    @Override
    public void connect() {
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.taskScheduler.setPoolSize(1);
        this.taskScheduler.afterPropertiesSet();
        CronTrigger cronTrigger = new CronTrigger(this.cronExpression);
        this.taskScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                CronMailAppender.this.sendLogItems();
            }
        }, (Trigger)cronTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.taskScheduler.destroy();
        List<String> list = this.messages;
        synchronized (list) {
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logItem(LogItem logItem) {
        String[] s;
        StringWriter writer = new StringWriter();
        writer.write(this.getLayout().format(logItem.getLoggingEvent()).trim());
        if (this.layout.ignoresThrowable() && (s = logItem.getLoggingEvent().getThrowableStrRep()) != null) {
            int len = s.length;
            for (int i = 0; i < len; ++i) {
                writer.write(Layout.LINE_SEP);
                writer.write(s[i]);
            }
        }
        String message = writer.toString();
        List<String> list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLogItems() {
        block13: {
            boolean useAuth;
            StringBuilder text = new StringBuilder();
            List<String> list = this.messages;
            synchronized (list) {
                int i = 0;
                for (String message : this.messages) {
                    if (this.messagesLimit > 0 && i >= this.messagesLimit) break;
                    if (!this.matchesRegex(message)) continue;
                    text.append(message);
                    text.append("\n");
                    ++i;
                }
                this.messages.clear();
            }
            if (text.length() == 0) {
                return;
            }
            Properties properties = new Properties();
            properties.put("mail.smtp.host", this.hostname);
            properties.put("mail.smtp.port", String.valueOf(this.port));
            properties.put("mail.mime.charset", "UTF8");
            if (this.useStartTsl) {
                properties.put("mail.smtp.starttls.enable", "true");
            }
            if (this.trustAllHosts) {
                properties.put("mail.smtp.ssl.trust", "*");
            }
            boolean bl = useAuth = this.username != null && this.password != null;
            if (useAuth) {
                properties.put("mail.smtp.auth", "true");
            }
            Session session = useAuth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(CronMailAppender.this.username, CronMailAppender.this.password);
                }
            }) : Session.getInstance((Properties)properties);
            session.setDebug(false);
            try {
                String message;
                message = new MimeMessage(session);
                message.setContent((Object)text.toString(), "text/plain; charset=utf-8;");
                if (this.getMachineName() != null && !this.getMachineName().isEmpty()) {
                    message.setSubject("Log messages from " + this.getMachineName());
                } else {
                    message.setSubject("Log messages");
                }
                message.setFrom((Address)new InternetAddress(this.fromEmail));
                String[] emails = this.toEmail.split("[,;]");
                Address[] addresses = new Address[emails.length];
                int i = 0;
                for (String recipient : emails) {
                    addresses[i++] = new InternetAddress(recipient);
                }
                message.setRecipients(Message.RecipientType.TO, addresses);
                message.setSentDate(Calendar.getInstance().getTime());
                Transport.send((Message)message);
            }
            catch (Exception e) {
                if (!this.isDebug()) break block13;
                e.printStackTrace();
            }
        }
    }

    private boolean matchesRegex(String message) {
        if (this.messageRegex == null || this.messageRegex.isEmpty()) {
            return true;
        }
        Pattern pattern = Pattern.compile(this.messageRegex, 32);
        return pattern.matcher(message).matches();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void setToEmail(String toEmail) {
        this.toEmail = toEmail;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setMessagesLimit(int messagesLimit) {
        this.messagesLimit = messagesLimit;
    }

    public void setUseStartTsl(boolean useStartTsl) {
        this.useStartTsl = useStartTsl;
    }

    public void setTrustAllHosts(boolean trustAllHosts) {
        this.trustAllHosts = trustAllHosts;
    }

    public void setMessageRegex(String messageRegex) {
        this.messageRegex = messageRegex;
    }
}

