/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.usage;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.usage.MethodInfo;
import si.nevensrok.common.usage.UsageLoggerConfig;
import si.nevensrok.common.usage.UsageRecorder;

public class UsageCollector
implements InitializingBean {
    private HashMap<String, MethodInfo> methodInfos = new HashMap();
    private UsageRecorder[] usageRecorders;

    public void setUsageRecorder(UsageRecorder usageRecorder) {
        this.usageRecorders = new UsageRecorder[]{usageRecorder};
    }

    public void setUsageRecorders(UsageRecorder[] usageRecorders) {
        this.usageRecorders = usageRecorders;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.usageRecorders == null) {
            throw new IllegalArgumentException("Property 'usageRecorders' is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object logMethodUsage(ProceedingJoinPoint point) throws Throwable {
        MethodInfo methodInfo;
        if (!this.isTrack(point)) {
            return point.proceed();
        }
        String methodName = this.generateMethodId(point);
        String beanName = this.getBeanName(point);
        Object result = null;
        Throwable error = null;
        long startTime = System.currentTimeMillis();
        try {
            result = point.proceed();
        }
        catch (Throwable e) {
            error = e;
        }
        long duration = System.currentTimeMillis() - startTime;
        if (duration < 0L) {
            duration = 0L;
        }
        Serializable serializable = this.methodInfos;
        synchronized (serializable) {
            methodInfo = this.methodInfos.get(methodName);
            if (methodInfo == null) {
                methodInfo = new MethodInfo(methodName, beanName);
                this.methodInfos.put(methodName, methodInfo);
            }
        }
        serializable = methodInfo;
        synchronized (serializable) {
            methodInfo.setCount(methodInfo.getCount() + 1);
            methodInfo.setDuration(methodInfo.getDuration() + duration);
            if (duration < methodInfo.getMinDuration()) {
                methodInfo.setMinDuration(duration);
            }
            if (duration > methodInfo.getMaxDuration()) {
                methodInfo.setMaxDuration(duration);
            }
        }
        if (error != null) {
            throw error;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCheckpoint() {
        UsageRecorder[] usageRecorderArray = this.methodInfos;
        synchronized (this.methodInfos) {
            ArrayList<MethodInfo> methodInfoList = new ArrayList<MethodInfo>(this.methodInfos.values());
            this.methodInfos.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Collections.sort(methodInfoList, new Comparator<MethodInfo>(){

                @Override
                public int compare(MethodInfo o1, MethodInfo o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (UsageRecorder usageRecorder : this.usageRecorders) {
                usageRecorder.logUsageRecords(methodInfoList);
            }
            return;
        }
    }

    private String generateMethodId(ProceedingJoinPoint point) {
        StringBuilder methodId = new StringBuilder();
        methodId.append(point.getTarget().getClass().getName());
        methodId.append("->");
        methodId.append(point.getSignature().getName());
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            methodId.append("(");
            boolean firstParameter = true;
            for (Class clazz : methodSignature.getParameterTypes()) {
                if (firstParameter) {
                    firstParameter = false;
                } else {
                    methodId.append(",");
                }
                methodId.append(clazz.getName());
            }
            methodId.append(")");
        }
        return methodId.toString();
    }

    private boolean isTrack(ProceedingJoinPoint point) {
        if (point.getSignature() instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            for (Annotation annotation : methodSignature.getMethod().getAnnotations()) {
                if (!(annotation instanceof UsageLoggerConfig)) continue;
                UsageLoggerConfig usageLoggerConfig = (UsageLoggerConfig)annotation;
                return usageLoggerConfig.value();
            }
        }
        return true;
    }

    private String getBeanName(ProceedingJoinPoint point) throws Exception {
        try {
            Object target = point.getTarget();
            for (Method method : target.getClass().getMethods()) {
                if (!method.getName().equalsIgnoreCase("getBeanName") || method.getParameterTypes().length != 0) continue;
                return (String)method.invoke(target, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

