/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessageSender;
import si.nevensrok.common.utils.ObjectUtil;

public class UdpBroadcastMessageSender
implements NetworkMessageSender,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UdpBroadcastMessageSender.class);
    private String[] addresses;
    private Integer port;
    private DatagramSocket[] sockets = null;
    private Object senderMonitor = new Object();

    public void setAddress(String address) {
        this.addresses = new String[]{address};
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        if (this.addresses == null) {
            LinkedList<String> addressList = new LinkedList<String>();
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            while (i.hasMoreElements()) {
                NetworkInterface networkInterface = i.nextElement();
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress broadcastAddress = interfaceAddress.getBroadcast();
                    if (broadcastAddress == null) continue;
                    addressList.add(broadcastAddress.getHostAddress());
                }
            }
            this.addresses = addressList.toArray(new String[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug("Connecting to UDP on multiple addresses on port {}", (Object)this.port);
        }
        try {
            this.sockets = new DatagramSocket[this.addresses.length];
            for (int i = 0; i < this.addresses.length; ++i) {
                this.sockets[i] = new DatagramSocket();
                this.sockets[i].connect(InetAddress.getByName(this.addresses[i]), this.port);
            }
        }
        catch (Exception e) {
            try {
                for (DatagramSocket socket : this.sockets) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to UDP on multiple addresses", e);
        }
    }

    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from multiple addresses on port {}", (Object)this.port);
        }
        try {
            for (DatagramSocket socket : this.sockets) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Object object) throws NetworkException {
        for (DatagramSocket socket : this.sockets) {
            try {
                byte[] data = ObjectUtil.serializeObject(object);
                DatagramPacket packet = new DatagramPacket(data, data.length);
                if (log.isTraceEnabled()) {
                    log.trace("Sending message to {}:{}, message data: {}", new Object[]{socket.getLocalAddress().getHostAddress(), this.port, data});
                }
                Object object2 = this.senderMonitor;
                synchronized (object2) {
                    socket.send(packet);
                }
            }
            catch (Exception e) {
                throw new NetworkException("Error sending message", e);
            }
        }
    }
}

