/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Date;
import java.util.LinkedList;
import si.nevensrok.common.logging.AbstractBackgroundAppender;
import si.nevensrok.common.logging.LogItem;

public class MongodbAppender
extends AbstractBackgroundAppender {
    private MongoClient mongoClient = null;
    private String hostname;
    private int port = 27017;
    private String username;
    private String password;
    private String database;
    private String collection;

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        block3: {
            try {
                if (this.mongoClient != null) {
                    this.mongoClient.close();
                }
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        this.mongoClient = null;
    }

    @Override
    public void logItem(LogItem logItem) {
        MongoClient mongoClient = this.getMongoClient();
        try {
            DB db = mongoClient.getDB(this.database);
            DBCollection dbCollection = db.getCollection(this.collection);
            BasicDBObject mongoDbData = new BasicDBObject();
            mongoDbData.put((Object)"eventDate", (Object)new Date(logItem.getTimeStamp()));
            mongoDbData.put((Object)"threadName", (Object)logItem.getThreadName());
            mongoDbData.put((Object)"category", (Object)logItem.getCategory());
            mongoDbData.put((Object)"logLevel", (Object)logItem.getLevel());
            mongoDbData.put((Object)"message", (Object)logItem.getMessage());
            mongoDbData.put((Object)"throwable", (Object)logItem.getThrowable());
            mongoDbData.put((Object)"locationClassName", (Object)logItem.getLocationClassName());
            mongoDbData.put((Object)"locationMethodName", (Object)logItem.getLocationMethodName());
            mongoDbData.put((Object)"locationLineNumber", (Object)logItem.getLocationLineNumber());
            mongoDbData.put((Object)"machineIp4", (Object)logItem.getMachineIp4());
            mongoDbData.put((Object)"machineIp6", (Object)logItem.getMachineIp6());
            mongoDbData.put((Object)"machineHostname", (Object)logItem.getMachineHostname());
            mongoDbData.put((Object)"machineName", (Object)logItem.getMachineName());
            mongoDbData.put((Object)"processName", (Object)logItem.getProcessName());
            dbCollection.insert(new DBObject[]{mongoDbData});
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            this.disconnect();
        }
    }

    private MongoClient getMongoClient() {
        block4: {
            if (this.isClosed()) {
                return null;
            }
            if (this.mongoClient == null) {
                try {
                    ServerAddress serverAddress = new ServerAddress(this.hostname, this.port);
                    LinkedList<MongoCredential> credentialsList = new LinkedList<MongoCredential>();
                    credentialsList.add(MongoCredential.createMongoCRCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()));
                    this.mongoClient = new MongoClient(serverAddress);
                }
                catch (Exception e) {
                    if (!this.isDebug()) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.mongoClient;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }
}

