/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.utils.ObjectUtil;

public class MessageReceiver {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiver.class);
    private Object messageMonitor = new Object();
    private LinkedList<NetworkMessage> messages = new LinkedList();
    private boolean open = true;

    public MessageReceiver(final DatagramSocket socket, final int bufferSize) {
        Thread thread = new Thread("Message receive thread for socket " + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug("Message receive thread started");
                }
                byte[] buffer = new byte[bufferSize];
                while (MessageReceiver.this.open) {
                    try {
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                        socket.receive(packet);
                        InetAddress sender = packet.getAddress();
                        Integer senderPort = packet.getPort();
                        byte[] data = new byte[packet.getLength()];
                        System.arraycopy(buffer, 0, data, 0, packet.getLength());
                        Object obj = ObjectUtil.deserializeObject(data);
                        NetworkMessage networkMessage = new NetworkMessage(sender, senderPort, obj);
                        if (log.isTraceEnabled()) {
                            log.trace("Received message: {}", (Object)networkMessage);
                        }
                        Object object = MessageReceiver.this.messageMonitor;
                        synchronized (object) {
                            MessageReceiver.this.messages.add(networkMessage);
                            MessageReceiver.this.messageMonitor.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Error while receiving message", (Throwable)e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Message receive thread stopped");
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.open = false;
        Object object = this.messageMonitor;
        synchronized (object) {
            this.messages.clear();
            this.messageMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkMessage getNextMessage() throws NetworkException {
        Object object = this.messageMonitor;
        synchronized (object) {
            while (this.messages.isEmpty() && this.open) {
                try {
                    this.messageMonitor.wait();
                }
                catch (Exception exception) {}
            }
            if (this.messages.isEmpty()) {
                throw new NetworkException("Connection closed");
            }
            return this.messages.removeFirst();
        }
    }
}

