/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.tcp;

import java.net.Socket;
import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import si.nevensrok.common.encryption.AesKeyGenerator;
import si.nevensrok.common.network.tcp.AesTcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.utils.HashUtil;

public class AesTcpNetworkServer
extends TcpNetworkServer {
    private byte[] key = null;
    private int keySize = 16;
    private String chipperInstance = "AES/ECB/PKCS5Padding";
    private SecretKey secretKey;

    public void setKey(byte[] key) {
        this.key = key;
    }

    public void setKeyAsString(String key) {
        this.key = HashUtil.generateHash(key.getBytes(Charset.forName("UTF8")), HashUtil.HashType.SHA256);
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setChipperInstance(String chipperInstance) {
        this.chipperInstance = chipperInstance;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.key == null) {
            throw new IllegalArgumentException("Property 'key' is required");
        }
        this.secretKey = AesKeyGenerator.generateKey(this.key, this.keySize);
        super.afterPropertiesSet();
    }

    @Override
    protected TcpNetworkConnection openTcpNetworkConnection(Socket socket) throws Exception {
        Cipher inputCipher = Cipher.getInstance(this.chipperInstance);
        inputCipher.init(2, this.secretKey);
        Cipher outputCipher = Cipher.getInstance(this.chipperInstance);
        outputCipher.init(1, this.secretKey);
        return new AesTcpNetworkConnection(socket, inputCipher, outputCipher);
    }
}

