/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.hazelcast;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.hazelcast.HazelcastDiscoveryPackage;
import si.nevensrok.common.hazelcast.HazelcastReplyPackage;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.udp.UdpBroadcastMessageSender;
import si.nevensrok.common.network.udp.UdpMessageReceiver;

public class HazelcastBroadcastDiscoverer {
    private static final Logger log = LoggerFactory.getLogger(HazelcastBroadcastDiscoverer.class);
    private Random random = new Random();
    private UdpMessageReceiver udpMessageReceiver = null;
    private Set<String> processedUuids = new HashSet<String>();
    private Set<String> members = new LinkedHashSet<String>();

    public HazelcastBroadcastDiscoverer(String broadcastDomain, int broadcastPort, int broadcastPortTryCount) {
        try {
            this.udpMessageReceiver = new UdpMessageReceiver();
            this.udpMessageReceiver.afterPropertiesSet();
            Thread thread = new Thread("Hazelcast broadcast discoverer"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (HazelcastBroadcastDiscoverer.this.udpMessageReceiver != null) {
                        try {
                            NetworkMessage networkMessage = HazelcastBroadcastDiscoverer.this.udpMessageReceiver.receiveMessage();
                            HazelcastReplyPackage hazelcastReplyPackage = (HazelcastReplyPackage)networkMessage.getData();
                            log.trace("Received package: {}", (Object)hazelcastReplyPackage);
                            String ip = networkMessage.getSender().getHostAddress();
                            for (Map.Entry<String, Integer> entry : hazelcastReplyPackage.getPorts().entrySet()) {
                                String uuid = entry.getKey();
                                Integer port = entry.getValue();
                                if (!HazelcastBroadcastDiscoverer.this.processedUuids.add(uuid)) continue;
                                Set set = HazelcastBroadcastDiscoverer.this.members;
                                synchronized (set) {
                                    HazelcastBroadcastDiscoverer.this.members.add(ip + ":" + port);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.trace("Error processing message", (Throwable)e);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            HazelcastDiscoveryPackage hazelcastDiscoveryPackage = new HazelcastDiscoveryPackage(broadcastDomain, this.udpMessageReceiver.getLocalPort());
            for (int j = 0; j < broadcastPortTryCount; ++j) {
                try {
                    int port = broadcastPort + j;
                    UdpBroadcastMessageSender udpBroadcastMessageSender = new UdpBroadcastMessageSender();
                    udpBroadcastMessageSender.setPort(port);
                    udpBroadcastMessageSender.afterPropertiesSet();
                    log.trace("Sending halecast discovery package on port {}", (Object)port);
                    udpBroadcastMessageSender.sendMessage(hazelcastDiscoveryPackage);
                    udpBroadcastMessageSender.destroy();
                    continue;
                }
                catch (Exception e) {
                    log.trace("Error sending broadcast message", (Throwable)e);
                }
            }
            Thread.sleep(200 + this.random.nextInt(500));
        }
        catch (Exception e) {
            log.trace("Error starting udp listener on port", (Throwable)e);
            try {
                this.udpMessageReceiver.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.udpMessageReceiver = null;
        }
    }

    public void close() {
        try {
            if (this.udpMessageReceiver != null) {
                this.udpMessageReceiver.destroy();
                this.udpMessageReceiver = null;
            }
        }
        catch (Exception e) {
            log.trace("Error closing udp message receiver", (Throwable)e);
        }
    }

    public Set<String> getMembers() {
        return this.members;
    }
}

